/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.craft.stat;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import smartin.miapi.Miapi;
import smartin.miapi.craft.stat.CraftingStat;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.registries.RegistryInventory;

public class StatRequirementMap {
    protected final Map<CraftingStat<?>, Object> raw = new HashMap();

    public <T> T get(CraftingStat<T> key) {
        return (T)this.raw.get(key);
    }

    public <T> T put(CraftingStat<T> key, T value) {
        return (T)this.raw.put(key, value);
    }

    public void putAll(StatRequirementMap other) {
        this.raw.putAll(other.raw);
    }

    public <T> StatRequirementMap set(CraftingStat<T> key, T val) {
        this.raw.put(key, val);
        return this;
    }

    public <E> E getOrDefault(CraftingStat<E> stat) {
        E val = this.get(stat);
        if (val == null) {
            return stat.getDefault();
        }
        return val;
    }

    public Map<CraftingStat<?>, Object> getRaw() {
        return this.raw;
    }

    public static class Codec
    implements com.mojang.serialization.Codec<StatRequirementMap> {
        private final ItemModule.ModuleInstance modules;

        public Codec(ItemModule.ModuleInstance modules) {
            this.modules = modules;
        }

        public <T> DataResult<Pair<StatRequirementMap, T>> decode(DynamicOps<T> ops, T input) {
            StatRequirementMap stats = new StatRequirementMap();
            MapLike map = (MapLike)ops.getMap(input).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to create map in StatRequirementMapCodec! -> {}", s));
            map.entries().forEach(p -> {
                String str = (String)ops.getStringValue(p.getFirst()).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to getVertexConsumer string value in StatRequirementMapCodec! -> {}", s));
                CraftingStat stat = RegistryInventory.craftingStats.get(str);
                Object element = p.getSecond();
                if (stat != null) {
                    if (element instanceof JsonElement) {
                        JsonElement json = (JsonElement)element;
                        stats.set(stat, stat.createFromJson(json, this.modules));
                    } else if (element instanceof Tag) {
                        Tag nbt = (Tag)element;
                        stats.set(stat, stat.createFromNbt(nbt));
                    } else {
                        stats.set(stat, stat.createFromJson((JsonElement)ExtraCodecs.f_252400_.parse(ops, element).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to turn instance into a JsonElement while decoding a StatRequirementMap! -> {}", s)), this.modules));
                    }
                }
            });
            return DataResult.success((Object)Pair.of((Object)stats, input));
        }

        public <T> DataResult<T> encode(StatRequirementMap input, DynamicOps<T> ops, T prefix) {
            HashMap map = new HashMap();
            input.raw.forEach((stat, inst) -> {
                Object obj = ExtraCodecs.f_252400_.encodeStart(ops, (Object)stat.saveToJson(inst)).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to turn instance into a JsonElement while encoding a StatRequirementMap! -> {}", s));
                map.put(ops.createString(RegistryInventory.craftingStats.findKey((CraftingStat)stat)), obj);
            });
            return DataResult.success((Object)ops.createMap(map));
        }
    }
}

