/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.datapack;

import dev.architectury.event.events.common.PlayerEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.MiapiRegistry;

public class ReloadEvents {
    public static MiapiRegistry<DataSyncer> dataSyncerRegistry = MiapiRegistry.getInstance(DataSyncer.class);
    private static List<String> receivedSyncer = new ArrayList<String>();
    protected static final String RELOAD_PACKET_ID = "miapi:events_reload_s2c";
    public static final Map<String, String> DATA_PACKS = Collections.synchronizedMap(new LinkedHashMap());
    public static Map<String, List<String>> syncedPaths = new HashMap<String, List<String>>();
    public static final ReloadEvent START = new ReloadEvent();
    public static final ReloadEvent MAIN = new ReloadEvent();
    public static final ReloadEvent END = new ReloadEvent();
    public static int reloadCounter = 0;
    private static long clientReloadTimeStart = System.nanoTime();

    public static void registerDataPackPathToSync(String modId, String path) {
        syncedPaths.computeIfAbsent(modId, k -> new ArrayList()).add(path);
    }

    public static void setup() {
        if (Environment.isClient()) {
            ReloadEvents.clientSetup();
        }
        Networking.registerC2SPacket(RELOAD_PACKET_ID, (buf, serverPlayerEntity) -> {
            boolean allowHandshake = buf.readBoolean();
            if (!allowHandshake) {
                Miapi.LOGGER.warn("Client " + serverPlayerEntity.m_20148_() + " rejected reload? this should never happen!");
                Miapi.server.m_213846_((Component)Component.m_237113_((String)("Client " + serverPlayerEntity.m_5446_() + " failed to reload.")));
            } else {
                ReloadEvents.triggerReloadOnClient(serverPlayerEntity);
            }
        });
        dataSyncerRegistry.register("data_packs", new DataSyncer(){

            @Override
            public FriendlyByteBuf createDataServer() {
                FriendlyByteBuf buf = Networking.createBuffer();
                buf.writeInt(DATA_PACKS.size());
                for (String key : DATA_PACKS.keySet()) {
                    buf.m_130070_(key);
                    buf.m_130070_(DATA_PACKS.get(key));
                }
                return buf;
            }

            @Override
            public void interpretDataClient(FriendlyByteBuf buffer) {
                int dataPackSize = buffer.readInt();
                HashMap<String, String> tempDataPack = new HashMap<String, String>(dataPackSize);
                for (int i = 0; i < dataPackSize; ++i) {
                    String key = buffer.m_130277_();
                    String value = buffer.m_130277_();
                    tempDataPack.put(key, value);
                }
                Minecraft.m_91087_().execute(() -> {
                    Map<String, String> map = DATA_PACKS;
                    synchronized (map) {
                        DATA_PACKS.clear();
                        DATA_PACKS.putAll(tempDataPack);
                    }
                    DataPackLoader.trigger(tempDataPack);
                    tempDataPack.clear();
                });
            }
        });
        PlayerEvent.PLAYER_JOIN.register(ReloadEvents::triggerReloadOnClient);
        START.subscribe(isClient -> ++reloadCounter);
        END.subscribe(isClient -> --reloadCounter);
        DataPackLoader.subscribe(dataPack -> {
            Map<String, String> map = DATA_PACKS;
            synchronized (map) {
                DATA_PACKS.clear();
                DATA_PACKS.putAll(dataPack);
            }
        });
    }

    public static void triggerReloadOnClient(ServerPlayer entity) {
        dataSyncerRegistry.getFlatMap().forEach((id, syncer) -> {
            FriendlyByteBuf buf = Networking.createBuffer();
            buf.m_130070_(id);
            buf.writeBytes(syncer.createDataServer().copy());
            Networking.sendS2C(RELOAD_PACKET_ID, entity, buf);
        });
    }

    public static boolean isInReload() {
        return reloadCounter != 0;
    }

    private static void clientSetup() {
        Networking.registerS2CPacket(RELOAD_PACKET_ID, buffer -> {
            if (receivedSyncer.isEmpty()) {
                clientReloadTimeStart = System.nanoTime();
            }
            String receivedID = buffer.m_130277_();
            receivedSyncer.add(receivedID);
            dataSyncerRegistry.get(receivedID).interpretDataClient((FriendlyByteBuf)buffer);
            if (receivedSyncer.size() == dataSyncerRegistry.getFlatMap().keySet().size()) {
                receivedSyncer.clear();
                Minecraft.m_91087_().execute(() -> {
                    ++reloadCounter;
                    START.fireEvent(true);
                    MAIN.fireEvent(true);
                    END.fireEvent(true);
                    --reloadCounter;
                    Miapi.LOGGER.info("Client load took " + (double)(System.nanoTime() - clientReloadTimeStart) / 1000.0 / 1000.0 + " ms");
                });
            }
        });
    }

    public static class ReloadEvent {
        private final Map<EventListener, Float> mainListeners = new HashMap<EventListener, Float>();

        public void subscribe(EventListener listener, float priority) {
            this.mainListeners.put(listener, Float.valueOf(priority));
        }

        public void subscribe(EventListener listener) {
            this.subscribe(listener, 0.0f);
        }

        public void unsubscribe(EventListener listener) {
            this.mainListeners.remove(listener);
        }

        public void fireEvent(boolean isClient) {
            this.mainListeners.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(eventListenerFloatEntry -> {
                try {
                    ((EventListener)eventListenerFloatEntry.getKey()).onEvent(isClient);
                }
                catch (Exception e) {
                    Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                }
            });
        }
    }

    public static interface EventListener {
        public void onEvent(boolean var1);
    }

    public static class DataPackLoader {
        protected static final List<EventListener> listeners = new ArrayList<EventListener>();

        public static void subscribe(EventListener listener) {
            listeners.add(listener);
        }

        public static void unsubscribe(EventListener listener) {
            listeners.remove(listener);
        }

        public static void trigger(Map<String, String> dataPack) {
            for (EventListener listener : listeners) {
                try {
                    listener.onEvent(dataPack);
                }
                catch (Exception e) {
                    Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                }
            }
        }

        public static interface EventListener {
            public void onEvent(Map<String, String> var1);
        }
    }

    public static interface DataSyncer {
        public FriendlyByteBuf createDataServer();

        public void interpretDataClient(FriendlyByteBuf var1);
    }
}

