/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.effects;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.redpxnda.nucleus.client.Rendering;
import com.redpxnda.nucleus.event.ClientEvents;
import com.redpxnda.nucleus.event.MiscEvents;
import com.redpxnda.nucleus.registry.effect.RenderingMobEffect;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.registries.RegistryInventory;

public class CryoStatusEffect
extends RenderingMobEffect {
    protected static final ResourceLocation ICE_LOCATION = new ResourceLocation("block/ice");

    public CryoStatusEffect() {
        super(MobEffectCategory.HARMFUL, 1160409);
        super.m_19472_(Attributes.f_22279_, "309da7c1-944e-4d5e-aad1-be2491a44695", -0.2, AttributeModifier.Operation.MULTIPLY_TOTAL);
        MiscEvents.LIVING_JUMP_POWER.register(player -> {
            MobEffectInstance instance = player.m_21124_((MobEffect)this);
            if (instance != null) {
                return CompoundEventResult.interruptFalse((Object)Float.valueOf(0.4f - Math.min(0.4f, (float)(instance.m_19564_() + 1) * 0.04f)));
            }
            return CompoundEventResult.pass();
        });
        MiapiEvents.LIVING_HURT_AFTER.register(event -> {
            MobEffectInstance instance;
            if (event.livingEntity.m_21023_((MobEffect)this) && (instance = event.livingEntity.m_21124_((MobEffect)this)) != null) {
                event.livingEntity.m_21195_((MobEffect)this);
                event.livingEntity.m_7292_(new MobEffectInstance((MobEffect)this, instance.m_19557_() - 30, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_()));
            }
            return EventResult.pass();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupOnClient() {
        MiscEvents.CAN_CLIENT_SPRINT.register(player -> {
            if (player.m_21023_(RegistryInventory.cryoStatusEffect)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientEvents.MODIFY_CAMERA_MOTION.register((mc, motion) -> {
            if (mc.f_91074_ != null && mc.f_91074_.m_21023_(RegistryInventory.cryoStatusEffect) && (motion.x != 0.0 || motion.y != 0.0)) {
                int amplifier = mc.f_91074_.m_21124_(RegistryInventory.cryoStatusEffect).m_19564_();
                motion.normalize();
                motion.div(Math.min((double)((float)(amplifier + 6) / 5.0f), 2.25));
            }
        });
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        super.m_6385_(entity, attributes, amplifier);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144205_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        super.m_6386_(entity, attributes, amplifier);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50126_.m_49966_()), entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 50, 0.5, 0.5, 0.5, 1.5);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderPost(MobEffectInstance instance, LivingEntity entity, float entityYaw, float partialTick, PoseStack matrixStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (entity.equals((Object)Minecraft.m_91087_().f_91074_) && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(ICE_LOCATION);
        VertexConsumer vc = multiBufferSource.m_6299_(RegistryInventory.Client.TRANSLUCENT_NO_CULL);
        matrixStack.m_85836_();
        AABB bb = entity.m_20191_().m_82383_(entity.m_20182_().m_82548_());
        double minX = Math.floor(bb.f_82288_ * 2.0) / 2.0;
        double maxX = Math.ceil(bb.f_82291_ * 2.0) / 2.0;
        double minZ = Math.floor(bb.f_82290_ * 2.0) / 2.0;
        double maxZ = Math.ceil(bb.f_82293_ * 2.0) / 2.0;
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        for (double z = minZ; z < maxZ; z += 1.0) {
            boolean isLeft = z == minZ || maxZ - minZ <= 1.0;
            boolean isRight = z + 1.0 >= maxZ || maxZ - minZ <= 1.0;
            for (double x = minX; x < maxX; x += 1.0) {
                boolean isFront = x == minX || maxX - minX <= 1.0;
                boolean isBack = x + 1.0 >= maxX || maxX - minX <= 1.0;
                for (double y = bb.f_82289_; y < bb.f_82292_; y += 1.0) {
                    boolean isBottom = y == bb.f_82289_ || bb.f_82292_ - bb.f_82289_ <= 1.0;
                    boolean isTop = y + 1.0 >= bb.f_82292_ || bb.f_82292_ - bb.f_82289_ <= 1.0;
                    matrixStack.m_85836_();
                    matrixStack.m_85837_(x, y + 1.0E-4, z);
                    for (int side = 0; side < 6; ++side) {
                        if (side == 0 && !isTop || side == 1 && !isBottom || side == 2 && !isRight || side == 3 && !isLeft || side == 4 && !isBack || side == 5 && !isFront) continue;
                        Rendering.addQuad((Vector3f[])Rendering.CUBE[side], (PoseStack)matrixStack, (VertexConsumer)vc, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f, (float)-0.5f, (float)0.5f, (float)0.5f, (float)sprite.m_118409_(), (float)sprite.m_118410_(), (float)sprite.m_118411_(), (float)sprite.m_118412_(), (int)packedLight);
                    }
                    matrixStack.m_85849_();
                }
            }
        }
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(MobEffectInstance instance, Minecraft minecraft, GuiGraphics graphics, float partialTick) {
        if (minecraft.f_91066_ == null || !minecraft.f_91066_.m_92176_().m_90612_()) {
            return false;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(ICE_LOCATION);
        Window window = Minecraft.m_91087_().m_91268_();
        graphics.m_280565_(0, 0, 0, window.m_85443_() / 2, window.m_85444_() / 2, sprite, 1.0f, 1.0f, 1.0f, 0.6f);
        return false;
    }

    public int tickUpdateInterval() {
        return 20;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration > 0;
    }
}

