/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.entity;

import dev.architectury.event.EventResult;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.entity.arrowhitbehaviours.EntityBounceBehaviour;
import smartin.miapi.entity.arrowhitbehaviours.EntityPierceBehaviour;
import smartin.miapi.entity.arrowhitbehaviours.ProjectileHitBehaviour;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.modules.abilities.util.WrappedSoundEvent;
import smartin.miapi.modules.properties.AirDragProperty;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.registries.RegistryInventory;

public class ItemProjectileEntity
extends AbstractArrow {
    public static final EntityDataAccessor<Byte> LOYALTY = SynchedEntityData.m_135353_(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Boolean> ENCHANTED = SynchedEntityData.m_135353_(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SPEED_DAMAGE = SynchedEntityData.m_135353_(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<ItemStack> THROWING_STACK = SynchedEntityData.m_135353_(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<ItemStack> BOW_ITEM_STACK = SynchedEntityData.m_135353_(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Float> WATER_DRAG = SynchedEntityData.m_135353_(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> PREFERRED_SLOT = SynchedEntityData.m_135353_(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public ItemStack thrownStack = ItemStack.f_41583_;
    protected boolean dealtDamage;
    public int returnTimer;
    public float waterDrag = 0.99f;
    public WrappedSoundEvent hitEntitySound = new WrappedSoundEvent(this.m_7239_(), 1.0f, 1.0f);
    public ProjectileHitBehaviour projectileHitBehaviour = new EntityBounceBehaviour();

    public ItemProjectileEntity(EntityType<? extends Entity> entityType, Level world) {
        super(entityType, world);
    }

    public ItemProjectileEntity(Level world, Position position, ItemStack itemStack) {
        super((EntityType)RegistryInventory.itemProjectileType.get(), position.m_7096_(), position.m_7098_(), position.m_7094_(), world);
        ItemStack stack = itemStack.m_41777_();
        stack.m_41764_(1);
        this.thrownStack = stack;
        this.f_19804_.m_135381_(THROWING_STACK, (Object)this.thrownStack);
        this.f_19804_.m_135381_(LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)stack)));
        this.f_19804_.m_135381_(ENCHANTED, (Object)stack.m_41790_());
        this.m_6043_();
        this.setup();
    }

    public ItemProjectileEntity(Level world, LivingEntity owner, ItemStack itemStack) {
        super((EntityType)RegistryInventory.itemProjectileType.get(), owner, world);
        ItemStack stack = itemStack.m_41777_();
        stack.m_41764_(1);
        this.thrownStack = stack.m_41777_();
        this.f_19804_.m_135381_(LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)stack)));
        this.f_19804_.m_135381_(ENCHANTED, (Object)stack.m_41790_());
        this.f_19804_.m_135381_(THROWING_STACK, (Object)this.thrownStack);
        this.f_19804_.m_135381_(BOW_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135381_(WATER_DRAG, (Object)Float.valueOf(this.waterDrag));
        this.f_19804_.m_135381_(SPEED_DAMAGE, (Object)true);
        this.f_19804_.m_135381_(PREFERRED_SLOT, (Object)-1);
        if (this.getBowItem().m_41619_() && owner != null) {
            this.setBowItem(owner.m_21211_());
        }
        this.setup();
        ((MiapiProjectileEvents.ItemProjectileDataTracker)MiapiProjectileEvents.MODULAR_PROJECTILE_DATA_TRACKER_SET.invoker()).dataTracker(this, this.m_20088_());
    }

    private void setup() {
        ItemStack projectileStack = this.m_7941_();
        this.m_36781_(AttributeProperty.getActualValue(projectileStack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_DAMAGE));
    }

    public void setPreferredSlot(int slotID) {
        this.f_19804_.m_135381_(PREFERRED_SLOT, (Object)slotID);
    }

    public void setBowItem(ItemStack bowItem) {
        this.f_19804_.m_135381_(BOW_ITEM_STACK, (Object)bowItem.m_41777_());
    }

    public ItemStack getBowItem() {
        return (ItemStack)this.f_19804_.m_135370_(BOW_ITEM_STACK);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ENCHANTED, (Object)false);
        this.f_19804_.m_135372_(THROWING_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(BOW_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(WATER_DRAG, (Object)Float.valueOf(0.99f));
        this.f_19804_.m_135372_(SPEED_DAMAGE, (Object)true);
        this.f_19804_.m_135372_(PREFERRED_SLOT, (Object)0);
        ((MiapiProjectileEvents.ItemProjectileDataTracker)MiapiProjectileEvents.MODULAR_PROJECTILE_DATA_TRACKER_INIT.invoker()).dataTracker(this, this.m_20088_());
    }

    public boolean getSpeedDamage() {
        return (Boolean)this.f_19804_.m_135370_(SPEED_DAMAGE);
    }

    public void setSpeedDamage(boolean speedDamage) {
        this.f_19804_.m_135381_(SPEED_DAMAGE, (Object)speedDamage);
    }

    public void m_8119_() {
        ItemStack asItem = this.m_7941_();
        if (((MiapiProjectileEvents.ModularProjectileTick)MiapiProjectileEvents.MODULAR_PROJECTILE_TICK.invoker()).tick(this).interruptsFurtherEvaluation()) {
            return;
        }
        if (this.f_36704_ > 4) {
            this.m_20256_(new Vec3(0.0, 0.0, 0.0));
            this.dealtDamage = true;
        }
        if (this.m_20183_().m_123342_() < this.m_9236_().m_141937_() - 50 && MiapiConfig.INSTANCE.server.enchants.betterLoyalty) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(LOYALTY);
        if (loyaltyLevel > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isOwnerAlive()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 targetDir = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + targetDir.f_82480_ * 0.015 * (double)loyaltyLevel, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double speedAdjustment = 0.05 * (double)loyaltyLevel;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(targetDir.m_82541_().m_82490_(speedAdjustment)));
                if (this.returnTimer == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.returnTimer;
            }
        }
        Vec3 vec3d = this.m_20184_();
        float m = (float)AirDragProperty.property.getValueSafe(asItem);
        if (this.m_20069_()) {
            m = 1.0f;
        }
        this.m_20256_(vec3d.m_82490_((double)m));
        super.m_8119_();
    }

    protected void m_6901_() {
        if (this.f_19797_ >= 24000) {
            this.m_146870_();
        }
    }

    protected boolean isOwnerAlive() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    public ItemStack m_7941_() {
        return ((ItemStack)this.f_19804_.m_135370_(THROWING_STACK)).m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 currentPosition, Vec3 nextPosition) {
        return this.dealtDamage ? null : super.m_6351_(currentPosition, nextPosition);
    }

    public void m_37251_(Entity shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        ItemStack projectileStack = this.m_7941_();
        speed = (float)Math.max(0.1, (double)speed + AttributeProperty.getActualValue(projectileStack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_SPEED));
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float g = -Mth.m_14031_((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        this.m_6686_(f, g, h, speed, divergence *= (float)Math.pow(12.0, -AttributeProperty.getActualValue(projectileStack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_ACCURACY)));
        Vec3 vec3d = shooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3d.f_82479_, shooter.m_20096_() ? 0.0 : vec3d.f_82480_, vec3d.f_82481_));
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        float damage = this.getProjectileDamage();
        if (this.m_36796_() > 0) {
            this.projectileHitBehaviour = new EntityPierceBehaviour();
            this.m_36767_((byte)(this.m_36796_() - 1));
        } else {
            this.projectileHitBehaviour = new EntityBounceBehaviour();
        }
        Entity owner = this.m_19749_();
        MiapiProjectileEvents.ModularProjectileEntityHitEvent event = new MiapiProjectileEvents.ModularProjectileEntityHitEvent(entityHitResult, this, this.m_269291_().m_269418_((AbstractArrow)this, owner), damage);
        EventResult result = ((MiapiProjectileEvents.ModularProjectileEntityHit)MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.invoker()).hit(event);
        if (result.interruptsFurtherEvaluation()) {
            if (this.projectileHitBehaviour != null) {
                this.projectileHitBehaviour.onHit(this, entityHitResult.m_82443_(), entityHitResult);
            }
            return;
        }
        damage = event.damage;
        this.dealtDamage = true;
        if (entity.m_6469_(event.damageSource, (float)Math.ceil(damage))) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)entity;
                if (owner instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)owner;
                    EnchantmentHelper.m_44823_((LivingEntity)victim, (Entity)livingOwner);
                    EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)victim);
                }
                this.m_7761_(victim);
            }
        }
        if (this.projectileHitBehaviour != null) {
            this.projectileHitBehaviour.onHit(this, entityHitResult.m_82443_(), entityHitResult);
        }
        MiapiProjectileEvents.ModularProjectileEntityHitEvent postEvent = new MiapiProjectileEvents.ModularProjectileEntityHitEvent(event.entityHitResult, this, event.damageSource, damage);
        EventResult postResult = ((MiapiProjectileEvents.ModularProjectileEntityHit)MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_POST_HIT.invoker()).hit(postEvent);
        if (postResult.interruptsFurtherEvaluation()) {
            return;
        }
        this.m_5496_(this.hitEntitySound.event(), this.hitEntitySound.volume(), this.hitEntitySound.pitch());
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        if (((MiapiProjectileEvents.ModularProjectileBlockHit)MiapiProjectileEvents.MODULAR_PROJECTILE_BLOCK_HIT.invoker()).hit(new MiapiProjectileEvents.ModularProjectileBlockHitEvent(blockHitResult, this)).interruptsFurtherEvaluation()) {
            if (this.projectileHitBehaviour != null) {
                this.projectileHitBehaviour.onBlockHit(this, blockHitResult);
            }
            return;
        }
        if (this.projectileHitBehaviour != null) {
            this.projectileHitBehaviour.onBlockHit(this, blockHitResult);
        }
        super.m_8060_(blockHitResult);
    }

    public float getProjectileDamage() {
        float damage = (float)this.m_36789_();
        if (this.getSpeedDamage()) {
            float speed = (float)this.m_20184_().m_82553_();
            damage = (float)Mth.m_14008_((double)((double)speed * (double)damage), (double)0.0, (double)2.147483647E9);
        }
        return damage;
    }

    public boolean hasChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.thrownStack);
    }

    protected boolean m_142470_(Player player) {
        int slotId = (Integer)this.f_19804_.m_135370_(PREFERRED_SLOT);
        if (((MiapiProjectileEvents.PlayerPickupEvent)MiapiProjectileEvents.MODULAR_PROJECTILE_PICK_UP.invoker()).pickup(player, this).interruptsFurtherEvaluation()) {
            return false;
        }
        switch (this.f_36705_) {
            case DISALLOWED: {
                return false;
            }
            case CREATIVE_ONLY: {
                if (EnchantmentHelper.m_44928_((ItemStack)this.m_7941_()) > 0 && this.m_150171_((Entity)player)) {
                    return true;
                }
                return player.m_150110_().f_35937_;
            }
            case ALLOWED: {
                boolean hasLoyalty;
                boolean bl = hasLoyalty = (Byte)this.f_19804_.m_135370_(LOYALTY) > 0;
                if (hasLoyalty && this.m_19749_() != null && !this.m_150171_((Entity)player)) {
                    return false;
                }
                if (slotId >= 0 && player.m_150109_().m_8020_(slotId).m_41619_()) {
                    return player.m_150109_().m_36040_(slotId, this.m_7941_());
                }
                return player.m_150109_().m_36054_(this.m_7941_());
            }
        }
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    public void setDamageToDeal(boolean hasDamage) {
        this.dealtDamage = !hasDamage;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player player) {
        super.m_6123_(player);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("ThrownItem", 10)) {
            this.thrownStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ThrownItem"));
            this.f_19804_.m_135381_(THROWING_STACK, (Object)this.thrownStack);
        }
        if (nbt.m_128425_("BowItem", 10)) {
            ItemStack bowItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("BowItem"));
            this.f_19804_.m_135381_(BOW_ITEM_STACK, (Object)bowItem);
        }
        if (nbt.m_128441_("WaterDrag")) {
            this.f_19804_.m_135381_(WATER_DRAG, (Object)Float.valueOf(nbt.m_128457_("WaterDrag")));
        }
        if (nbt.m_128441_("SpeedDamage")) {
            this.f_19804_.m_135381_(SPEED_DAMAGE, (Object)nbt.m_128471_("SpeedDamage"));
        }
        if (nbt.m_128441_("PreferredSlot")) {
            this.f_19804_.m_135381_(PREFERRED_SLOT, (Object)nbt.m_128451_("PreferredSlot"));
        }
        this.dealtDamage = nbt.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.thrownStack)));
        ((MiapiProjectileEvents.ItemProjectileCompound)MiapiProjectileEvents.MODULAR_PROJECTILE_NBT_READ.invoker()).nbtEvent(this, nbt);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("ThrownItem", (Tag)this.thrownStack.m_41739_(new CompoundTag()));
        nbt.m_128365_("BowItem", (Tag)this.getBowItem().m_41739_(new CompoundTag()));
        nbt.m_128379_("DealtDamage", this.dealtDamage);
        nbt.m_128350_("WaterDrag", ((Float)this.f_19804_.m_135370_(WATER_DRAG)).floatValue());
        nbt.m_128379_("SpeedDamage", ((Boolean)this.f_19804_.m_135370_(SPEED_DAMAGE)).booleanValue());
        nbt.m_128405_("PreferredSlot", ((Integer)this.f_19804_.m_135370_(PREFERRED_SLOT)).intValue());
        ((MiapiProjectileEvents.ItemProjectileCompound)MiapiProjectileEvents.MODULAR_PROJECTILE_NBT_WRITE.invoker()).nbtEvent(this, nbt);
    }

    protected float m_6882_() {
        return this.waterDrag;
    }

    public boolean m_6000_(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }
}

