/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.conditions.ConditionManager;

public class MiapiReloadListenerForge
extends SimplePreparableReloadListener<Map<String, String>> {
    static long timeStart;

    protected void apply(Map<String, String> prepared, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<String, String> dataMap = new HashMap<String, String>(prepared);
        HashMap<String, String> filteredMap = new HashMap<String, String>();
        dataMap.forEach((key, value) -> {
            if (!key.endsWith(".json")) {
                filteredMap.put((String)key, (String)value);
                return;
            }
            try {
                JsonObject element = (JsonObject)Miapi.gson.fromJson(value, JsonObject.class);
                if (!element.has("load_condition")) {
                    filteredMap.put((String)key, (String)value);
                    return;
                }
                boolean allowed = ConditionManager.get(element.get("load_condition")).isAllowed(new ConditionManager.ConditionContext(){

                    @Override
                    public ConditionManager.ConditionContext copy() {
                        return this;
                    }

                    @Override
                    public List<Component> getReasons() {
                        return new ArrayList<Component>();
                    }
                });
                if (allowed) {
                    element.remove("load_condition");
                    Miapi.LOGGER.info("redid " + key);
                    filteredMap.put((String)key, Miapi.gson.toJson((JsonElement)element));
                }
            }
            catch (Exception e) {
                filteredMap.put((String)key, (String)value);
            }
        });
        ReloadEvents.DataPackLoader.trigger(filteredMap);
        ReloadEvents.MAIN.fireEvent(false);
        ReloadEvents.END.fireEvent(false);
        Miapi.LOGGER.info("Server load took " + (double)(System.nanoTime() - timeStart) / 1000.0 / 1000.0 + " ms");
        --ReloadEvents.reloadCounter;
        if (Miapi.server != null) {
            Miapi.server.m_6846_().m_11314_().forEach(ReloadEvents::triggerReloadOnClient);
        }
    }

    protected Map<String, String> prepare(ResourceManager manager, ProfilerFiller profiler) {
        ++ReloadEvents.reloadCounter;
        timeStart = System.nanoTime();
        ReloadEvents.START.fireEvent(false);
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        ReloadEvents.syncedPaths.forEach((modID, dataPaths) -> dataPaths.forEach(dataPath -> {
            Map map = manager.m_214160_(dataPath, fileName -> true);
            map.forEach((identifier, resources) -> {
                if (identifier.m_135827_().equals(modID)) {
                    resources.forEach(resource -> {
                        try {
                            BufferedReader reader = resource.m_215508_();
                            String dataString = reader.lines().collect(Collectors.joining());
                            String fullPath = identifier.m_135815_();
                            data.put(fullPath, dataString);
                        }
                        catch (Exception e) {
                            Miapi.LOGGER.warn("Error Loading Resource" + identifier + " " + resources);
                        }
                    });
                }
            });
        }));
        return data;
    }
}

