/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge.compat;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.extensions.IForgeItem;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.abilities.toolabilities.AxeAbility;
import smartin.miapi.modules.abilities.toolabilities.HoeAbility;
import smartin.miapi.modules.abilities.toolabilities.ShovelAbility;
import smartin.miapi.modules.properties.AbilityMangerProperty;
import smartin.miapi.modules.properties.DurabilityProperty;
import smartin.miapi.modules.properties.EnchantAbilityProperty;
import smartin.miapi.modules.properties.EquipmentSlotProperty;
import smartin.miapi.modules.properties.IsPiglinGold;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;

public interface ModularItemInject
extends IForgeItem {
    default public Multimap<Attribute, AttributeModifier> getAttributeModifiersModular(EquipmentSlot slot, ItemStack stack) {
        ArrayListMultimap attributeModifiers = ArrayListMultimap.create();
        ((MiapiEvents.ItemStackAttributeEvent)MiapiEvents.ITEM_STACK_ATTRIBUTE_EVENT.invoker()).adjust(new MiapiEvents.ItemStackAttributeEventHolder(stack, slot, (Multimap<Attribute, AttributeModifier>)attributeModifiers));
        return attributeModifiers;
    }

    default public boolean makesPiglinsNeutralModular(ItemStack stack, LivingEntity wearer) {
        return IsPiglinGold.isPiglinGoldItem(stack);
    }

    default public EquipmentSlot getEquipmentSlotModular(ItemStack stack) {
        return EquipmentSlotProperty.getSlot(stack);
    }

    default public int getMaxDamageModular(ItemStack stack) {
        return (int)DurabilityProperty.property.getValueSafe(stack);
    }

    default public boolean isCorrectToolForDropsModular(ItemStack stack, BlockState state) {
        return MiningLevelProperty.isSuitable(stack, state);
    }

    default public boolean canPerformActionModular(ItemStack stack, ToolAction toolAction) {
        if (stack.m_41720_() instanceof ModularItem) {
            if (toolAction.equals(ToolActions.AXE_DIG)) {
                return MiningLevelProperty.isSuitable(stack, "axe");
            }
            if (toolAction.equals(ToolActions.PICKAXE_DIG)) {
                return MiningLevelProperty.isSuitable(stack, "pickaxe");
            }
            if (toolAction.equals(ToolActions.SHOVEL_DIG)) {
                return MiningLevelProperty.isSuitable(stack, "shovel");
            }
            if (toolAction.equals(ToolActions.HOE_DIG)) {
                return MiningLevelProperty.isSuitable(stack, "hoe");
            }
            if (toolAction.equals(ToolActions.SHEARS_DIG)) {
                return MiningLevelProperty.isSuitable(stack, "shear");
            }
            if (toolAction.equals(ToolActions.SWORD_DIG)) {
                return MiningLevelProperty.isSuitable(stack, "sword");
            }
            if (ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction)) {
                return AbilityMangerProperty.get(stack).stream().anyMatch(AxeAbility.class::isInstance);
            }
            if (ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction)) {
                return AbilityMangerProperty.get(stack).stream().anyMatch(HoeAbility.class::isInstance);
            }
            if (ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction)) {
                return AbilityMangerProperty.get(stack).stream().anyMatch(ShovelAbility.class::isInstance);
            }
        }
        return false;
    }

    default public int getEnchantmentValueModular(ItemStack stack) {
        return (int)EnchantAbilityProperty.getEnchantAbility(stack);
    }
}

