/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge.compat.epic_fight;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import yesman.epicfight.api.data.reloader.ItemCapabilityReloadListener;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class EpicFightCompatProperty
implements ModuleProperty {
    public static EpicFightCompatProperty property;
    public static String KEY;

    public EpicFightCompatProperty() {
        property = this;
        ModularItemCache.setSupplier(KEY, EpicFightCompatProperty::createCache);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) {
        return EpicFightCompatProperty.loadJsonData(data) != null;
    }

    public static CapabilityItem loadJsonData(JsonElement element) {
        try {
            CompoundTag compound = CompoundTag.f_128325_.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).result().orElse(null);
            if (compound == null) {
                return null;
            }
            return ItemCapabilityReloadListener.deserializeWeapon((Item)Items.f_41852_, (CompoundTag)compound);
        }
        catch (Exception e) {
            Miapi.LOGGER.error("Failed to load epic fight data!", (Throwable)e);
            return null;
        }
    }

    public static CapabilityItem get(ItemStack itemStack) {
        return (CapabilityItem)ModularItemCache.getRaw(itemStack, KEY);
    }

    public static CapabilityItem createCache(ItemStack stack) {
        JsonElement data = ItemModule.getMergedProperty(stack, (ModuleProperty)property);
        if (data == null) {
            return null;
        }
        return EpicFightCompatProperty.loadJsonData(data);
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        if (type == MergeType.SMART || type == MergeType.EXTEND) {
            return toMerge;
        }
        if (type == MergeType.OVERWRITE) {
            return old;
        }
        return ModuleProperty.super.merge(old, toMerge, type);
    }

    static {
        KEY = "epic_fight";
    }
}

