/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.injectors;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.redpxnda.nucleus.util.InterfaceDispatcher;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.TagProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class PropertySubstitution {
    public static int injectorsCount = 0;
    public static final Map<String, TargetSelector> targetSelectors = new HashMap<String, TargetSelector>();
    public static final InterfaceDispatcher<TargetSelector> targetSelectionDispatcher = InterfaceDispatcher.of(targetSelectors, (String)"type", (Object[])new TargetSelector[0]);
    public static final Map<String, ValueResolver> valueResolvers = new HashMap<String, ValueResolver>();
    public static final InterfaceDispatcher<ValueResolver> valueResolverDispatcher = InterfaceDispatcher.of(valueResolvers, (String)"mode", (Object[])new ValueResolver[0]);

    public static JsonInjector getInjector(JsonObject injectionJson) {
        return json -> PropertySubstitution.getInjectionReplacementFor(injectionJson, json);
    }

    public static JsonObject getInjectionReplacementFor(JsonObject injectionData, JsonObject toReplace) {
        JsonObject replacement = toReplace.deepCopy();
        HashMap storedValues = new HashMap();
        JsonElement jsonElement = injectionData.get("read");
        if (jsonElement instanceof JsonObject) {
            JsonObject reader = (JsonObject)jsonElement;
            reader.asMap().forEach((name, data) -> storedValues.put(name, PropertySubstitution.getValueFromLocator((JsonObject)toReplace, (String)data.getAsString()).target));
        }
        if ((jsonElement = injectionData.get("remove")) instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            array.forEach(removeLocation -> {
                JsonElement patt2872$temp;
                TargetHolder holder = PropertySubstitution.getValueFromLocator(replacement, removeLocation.getAsString());
                JsonElement patt2504$temp = holder.parent;
                if (patt2504$temp instanceof JsonObject) {
                    JsonObject object = (JsonObject)patt2504$temp;
                    if (holder.key != null) {
                        JsonElement removed = object.remove(holder.key);
                        if (removed != null) return;
                        Miapi.LOGGER.warn("Failed to remove key '" + removeLocation + "' (object fail) for PropertySubstitution!\nOriginal object: " + toReplace);
                        return;
                    }
                }
                if (!((patt2872$temp = holder.parent) instanceof JsonArray)) return;
                JsonArray arr = (JsonArray)patt2872$temp;
                boolean bl = arr.remove(holder.target);
                if (bl) return;
                Miapi.LOGGER.warn("Failed to remove key '" + removeLocation + "' (array fail) for PropertySubstitution!\nOriginal object: " + toReplace);
            });
        }
        if ((jsonElement = injectionData.get("write")) instanceof JsonObject) {
            JsonObject outer = (JsonObject)jsonElement;
            outer.asMap().forEach((key, element) -> {
                if (!(element instanceof JsonObject)) {
                    Miapi.LOGGER.warn("Write field for PropertySubstitution contains a non JSON object element: '" + element + "'");
                    return;
                }
                JsonObject object = (JsonObject)element;
                TargetHolder holder = PropertySubstitution.getValueFromLocator(replacement, key);
                JsonElement targetReplacement = ((ValueResolver)valueResolverDispatcher.dispatcher()).resolve((JsonElement)object, holder.target, storedValues);
                holder.set(targetReplacement);
            });
        }
        return replacement;
    }

    public static MergeType getMergeType(String stringRepresentation) {
        return switch (stringRepresentation) {
            case "smart" -> MergeType.SMART;
            case "extend" -> MergeType.EXTEND;
            default -> MergeType.OVERWRITE;
        };
    }

    public static TargetHolder getValueFromLocator(JsonObject root, String path) {
        JsonObject currentTarget = root;
        JsonObject parentObject = null;
        Integer targetIndex = null;
        String targetKey = null;
        String[] segments = path.split("(?<!~)\\.(?!~)");
        int index = 0;
        for (String segment : segments) {
            parentObject = currentTarget;
            ++index;
            if ((segment = segment.replace("~~", "")).matches("\\[\\d+]$") && currentTarget instanceof JsonArray) {
                JsonArray array = (JsonArray)currentTarget;
                int pos = Integer.parseInt(segment.substring(1, segment.length() - 1));
                if (pos >= array.size() || pos < 0) {
                    Miapi.LOGGER.error("Invalid path for PropertySubstitution found! Token '" + segment + "'(split #" + index + ") in '" + path + "' is invalid: Array index exceeds length of array.\nArray: " + array + "\nRoot object: " + root);
                    throw new RuntimeException("Failed to parse PropertySubstitution! See above error.");
                }
                currentTarget = array.get(pos);
                targetIndex = pos;
                targetKey = null;
                continue;
            }
            if (currentTarget instanceof JsonObject) {
                JsonObject obj = currentTarget;
                JsonElement element = obj.get(segment);
                if (element == null) {
                    Miapi.LOGGER.error("Invalid path for PropertySubstitution found! Token '" + segment + "'(split #" + index + ") in '" + path + " does not match any element in target object.\nLast target object: " + obj + "\nRoot object: " + root);
                    throw new RuntimeException("Failed to parse PropertySubstitution! See above error.");
                }
                currentTarget = element;
                targetKey = segment;
                targetIndex = null;
                continue;
            }
            Miapi.LOGGER.warn("Expected path end for PropertySubstitution, but instead it continues! Cutting off early.\nCurrent segment: " + segment + "\nSegment Index: " + index + "\nWhole path: " + path + "\nCurrent target object: " + (JsonElement)currentTarget + "\nRoot object: " + root);
            break;
        }
        return new TargetHolder((JsonElement)currentTarget, (JsonElement)parentObject, targetIndex, targetKey);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ JsonElement lambda$static$7(JsonElement input, JsonElement originalTarget, Map storedValues) {
        block4: {
            if (!(input instanceof JsonObject)) {
                return originalTarget;
            }
            object = (JsonObject)input;
            if (!(originalTarget instanceof JsonArray)) break block4;
            array = (JsonArray)originalTarget;
            val = object.get("value");
            if (val == null) {
                Miapi.LOGGER.warn("Failed to found key 'value' for append value resolver in a PropertySubstitution! Returning original instead.");
                return originalTarget;
            }
            if (!(val instanceof JsonArray)) ** GOTO lbl-1000
            valArray = (JsonArray)val;
            if (!object.has("insert_as_array")) {
                adder = (Consumer<JsonArray>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$static$5(com.google.gson.JsonArray com.google.gson.JsonArray ), (Lcom/google/gson/JsonArray;)V)((JsonArray)valArray);
            } else lbl-1000:
            // 2 sources

            {
                adder = (Consumer<JsonArray>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$static$6(com.google.gson.JsonElement com.google.gson.JsonArray ), (Lcom/google/gson/JsonArray;)V)((JsonElement)val);
            }
            newArray = array.deepCopy();
            adder.accept(newArray);
            return newArray;
        }
        Miapi.LOGGER.warn("Target for append value resolver in a PropertySubstitution is not an array nor a string! Returning original value.");
        return originalTarget;
    }

    private static /* synthetic */ void lambda$static$6(JsonElement val, JsonArray arr) {
        arr.add(val);
    }

    private static /* synthetic */ void lambda$static$5(JsonArray valArray, JsonArray arr) {
        arr.addAll(valArray);
    }

    static {
        valueResolvers.put("exact", (input, originalTarget, storedValues) -> {
            if (!(input instanceof JsonObject)) {
                return originalTarget;
            }
            JsonObject object = (JsonObject)input;
            JsonElement val = object.get("value");
            if (val == null) {
                Miapi.LOGGER.warn("Failed to found key 'value' for exact value resolver in a PropertySubstitution! Returning original instead.");
                return originalTarget;
            }
            return val;
        });
        valueResolvers.put("append", PropertySubstitution::lambda$static$7);
        valueResolvers.put("calculate", (input, originalTarget, storedValues) -> {
            JsonPrimitive prim;
            if (!(input instanceof JsonObject)) {
                return originalTarget;
            }
            JsonObject object = (JsonObject)input;
            JsonElement val = object.get("value");
            if (!(val instanceof JsonPrimitive) || !(prim = (JsonPrimitive)val).isString()) {
                Miapi.LOGGER.warn("Key 'value' for calculate value resolver in a PropertySubstitution is either missing or not a string! Returning original instead.");
                return originalTarget;
            }
            String expression = prim.getAsString();
            Pattern pattern = Pattern.compile("\\[(.*?)]");
            Matcher matcher = pattern.matcher(expression);
            while (matcher.find()) {
                String targetVariable = matcher.group(1);
                JsonElement value = (JsonElement)storedValues.get(targetVariable);
                if (!(value instanceof JsonPrimitive)) {
                    Miapi.LOGGER.error("Target value for stored variable '" + targetVariable + "' referenced in calulcate value resolver in a PropertySubstitution is not a JSON primitive!");
                    throw new RuntimeException();
                }
                expression = expression.replace("[" + targetVariable + "]", value.getAsString());
            }
            return new JsonPrimitive((Number)StatResolver.resolveCalculation(expression));
        });
        valueResolvers.put("replace", (input, originalTarget, storedValues) -> {
            JsonPrimitive prim;
            if (!(input instanceof JsonObject)) {
                return originalTarget;
            }
            JsonObject object = (JsonObject)input;
            JsonElement val = object.get("value");
            if (!(val instanceof JsonPrimitive) || !(prim = (JsonPrimitive)val).isString()) {
                Miapi.LOGGER.warn("Key 'value' for replace value resolver in a PropertySubstitution is either missing or not a string! Returning original instead.");
                return originalTarget;
            }
            String string = prim.getAsString();
            Pattern pattern = Pattern.compile("\\[(.*?)]");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String targetVar = matcher.group(1);
                JsonElement value = (JsonElement)storedValues.get(targetVar);
                string = string.replace("[" + targetVar + "]", value.getAsString());
            }
            return new JsonPrimitive(string);
        });
        targetSelectors.put("modules", (root, injector) -> {
            JsonElement patt12755$temp;
            JsonElement patt12488$temp;
            JsonElement patt12263$temp;
            JsonArray array;
            if (!(root instanceof JsonObject)) {
                throw new JsonParseException("Failed to load Miapi module injection! Not a json object -> " + root);
            }
            JsonObject object = (JsonObject)root;
            ArrayList modules = new ArrayList();
            JsonElement patt11934$temp = object.get("keys");
            if (patt11934$temp instanceof JsonArray) {
                array = (JsonArray)patt11934$temp;
                array.forEach(moduleKey -> {
                    ItemModule module = ItemModule.moduleRegistry.get(moduleKey.getAsString());
                    if (module == null) {
                        return;
                    }
                    modules.add(module);
                });
            }
            if ((patt12263$temp = object.get("tags")) instanceof JsonArray) {
                array = (JsonArray)patt12263$temp;
                array.forEach(tag -> modules.addAll(TagProperty.getModulesWithTag(tag.getAsString())));
            }
            if ((patt12488$temp = object.get("regex")) instanceof JsonPrimitive) {
                JsonPrimitive prim = (JsonPrimitive)patt12488$temp;
                ItemModule.moduleRegistry.getFlatMap().forEach((key, module) -> {
                    if (key.matches(prim.getAsString())) {
                        modules.add(module);
                    }
                });
            }
            if ((patt12755$temp = object.get("blacklist")) instanceof JsonArray) {
                array = (JsonArray)patt12755$temp;
                array.forEach(moduleKey -> {
                    ItemModule module = ItemModule.moduleRegistry.get(moduleKey.getAsString());
                    if (module == null) {
                        return;
                    }
                    modules.remove(module);
                });
            }
            modules.forEach(module -> {
                JsonObject moduleJson = new JsonObject();
                module.getProperties().forEach((arg_0, arg_1) -> ((JsonObject)moduleJson).add(arg_0, arg_1));
                JsonObject replacement = injector.getReplacement(moduleJson);
                module.getProperties().clear();
                replacement.asMap().forEach((key, value) -> {
                    ModuleProperty property = RegistryInventory.moduleProperties.get((String)key);
                    if (property == null) {
                        return;
                    }
                    try {
                        property.load(module.getName(), (JsonElement)value, Environment.isClient());
                    }
                    catch (Exception ex) {
                        Miapi.LOGGER.error("Property load error whilst loading PropertySubstitution injection data for a module!");
                        throw new RuntimeException(ex);
                    }
                    module.getProperties().put((String)key, (JsonElement)value);
                });
            });
        });
    }

    public static interface JsonInjector {
        public JsonObject getReplacement(JsonObject var1);
    }

    public record TargetHolder(JsonElement target, @Nullable JsonElement parent, @Nullable Integer index, @Nullable String key) {
        /*
         * Enabled aggressive block sorting
         */
        public void set(JsonElement newValue) {
            JsonElement jsonElement = this.parent;
            if (jsonElement instanceof JsonObject) {
                JsonObject object = (JsonObject)jsonElement;
                if (this.key != null) {
                    object.add(this.key, newValue);
                    return;
                }
            }
            if (!((jsonElement = this.parent) instanceof JsonArray)) return;
            JsonArray array = (JsonArray)jsonElement;
            if (this.index == null) return;
            array.set(this.index.intValue(), newValue);
        }
    }

    public static interface ValueResolver {
        public JsonElement resolve(JsonElement var1, JsonElement var2, Map<String, JsonElement> var3);
    }

    public static interface TargetSelector {
        public void triggerTargetFrom(JsonElement var1, JsonInjector var2);
    }
}

