/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item;

import com.google.gson.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.util.TriConsumer;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.EnchantmentProperty;
import smartin.miapi.modules.properties.ItemIdProperty;
import smartin.miapi.registries.RegistryInventory;

public class ItemToModularConverter
implements ModularItemStackConverter.ModularConverter {
    public Map<String, ItemStack> regexes = new ConcurrentHashMap<String, ItemStack>();

    public ItemToModularConverter() {
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "modular_converter", this.regexes, (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> {
            TypeToken<Map<String, ItemModule.ModuleInstance>> token = new TypeToken<Map<String, ItemModule.ModuleInstance>>(){};
            Map dataMap = (Map)Miapi.gson.fromJson(data, token.getType());
            dataMap.forEach((itemId, moduleString) -> {
                ItemStack stack = new ItemStack((ItemLike)RegistryInventory.modularItem);
                moduleString.writeToItem(stack);
                this.regexes.put((String)itemId, stack);
            });
        }), 1.0f);
        ReloadEvents.END.subscribe(isClient -> Miapi.LOGGER.info("Loaded " + this.regexes.size() + " Modular Converters"));
    }

    public boolean preventConvert(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null) {
            if (nbt.m_128423_("CustomModelData") != null) {
                return true;
            }
            if (nbt.m_128423_("SpellboundItem") != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack convert(ItemStack stack) {
        if (this.preventConvert(stack)) {
            return stack.m_41777_();
        }
        for (Map.Entry<String, ItemStack> entry : this.regexes.entrySet()) {
            if (!BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString().matches(entry.getKey())) continue;
            ItemStack nextStack = entry.getValue().m_41777_();
            nextStack.m_41751_(stack.m_41777_().m_41783_());
            nextStack.m_41784_().m_128365_("miapi_modules", entry.getValue().m_41783_().m_128423_("miapi_modules"));
            EnchantmentHelper.m_44831_((ItemStack)stack).forEach((enchantment, integer) -> {
                if (EnchantmentProperty.isAllowed(nextStack, enchantment)) {
                    nextStack.m_41663_(enchantment, integer.intValue());
                } else {
                    Miapi.LOGGER.info("enchantment is not allowed");
                }
            });
            nextStack.m_41764_(stack.m_41613_());
            return ItemIdProperty.changeId(nextStack);
        }
        return stack;
    }
}

