/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.registries.RegistryInventory;

public class MaterialSmithingRecipe
implements SmithingRecipe {
    final String startMaterial;
    final String resultMaterial;
    final Ingredient smithingTemplate;
    final Ingredient addition;
    final ResourceLocation id;

    public MaterialSmithingRecipe(ResourceLocation id, Ingredient template, String baseMaterial, Ingredient addition, String resultMaterial) {
        this.startMaterial = baseMaterial;
        this.resultMaterial = resultMaterial;
        this.smithingTemplate = template;
        this.addition = addition;
        this.id = id;
    }

    public boolean m_266166_(ItemStack stack) {
        return this.smithingTemplate.test(stack);
    }

    public boolean m_266343_(ItemStack stack) {
        if (stack.m_41720_() instanceof VisualModularItem) {
            ItemModule.ModuleInstance instance = ItemModule.getModules(stack);
            return instance.allSubModules().stream().anyMatch(module -> {
                Material material = MaterialProperty.getMaterial(module);
                if (material != null) {
                    return material.getKey().equals(this.startMaterial);
                }
                return false;
            });
        }
        return false;
    }

    public boolean m_266253_(ItemStack stack) {
        return this.addition.test(stack);
    }

    public boolean m_5818_(Container inventory, Level world) {
        return this.m_266166_(inventory.m_8020_(0)) && this.m_266343_(inventory.m_8020_(1)) && this.addition.test(inventory.m_8020_(2));
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        ItemStack old = inventory.m_8020_(1).m_41777_();
        if (old.m_41720_() instanceof VisualModularItem) {
            ItemModule.ModuleInstance instance = ItemModule.getModules(old).copy();
            instance.allSubModules().forEach(module -> {
                Material material = MaterialProperty.getMaterial(module);
                if (material != null && material.getKey().equals(this.startMaterial)) {
                    MaterialProperty.setMaterial(module, this.resultMaterial);
                }
            });
            instance.writeToItem(old);
        }
        MiapiEvents.MaterialCraft data = new MiapiEvents.MaterialCraft(old);
        ((MiapiEvents.SmithingEvent)MiapiEvents.SMITHING_EVENT.invoker()).craft(data);
        return data.itemStack;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryInventory.serializer;
    }

    public static class Serializer
    implements RecipeSerializer<MaterialSmithingRecipe> {
        public MaterialSmithingRecipe read(ResourceLocation identifier, JsonObject jsonObject) {
            Ingredient template = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"template"));
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)jsonObject, (String)"addition"));
            String base = jsonObject.get("base").getAsString();
            String result = jsonObject.get("result").getAsString();
            return new MaterialSmithingRecipe(identifier, template, base, addition, result);
        }

        public MaterialSmithingRecipe read(ResourceLocation identifier, FriendlyByteBuf packetByteBuf) {
            Ingredient template = Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf);
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf);
            String base = packetByteBuf.m_130277_();
            String result = packetByteBuf.m_130277_();
            return new MaterialSmithingRecipe(identifier, template, base, addition, result);
        }

        public void write(FriendlyByteBuf packetByteBuf, MaterialSmithingRecipe smithingTransformRecipe) {
            smithingTransformRecipe.smithingTemplate.m_43923_(packetByteBuf);
            smithingTransformRecipe.addition.m_43923_(packetByteBuf);
            packetByteBuf.m_130070_(smithingTransformRecipe.startMaterial);
            packetByteBuf.m_130070_(smithingTransformRecipe.resultMaterial);
        }
    }
}

