/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular;

import com.ezylang.evalex.Expression;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.codec.misc.CustomIntermediateCodec;
import com.redpxnda.nucleus.codec.misc.IntermediateCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.EvalExResolverStuff;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;

public class StatResolver {
    private static final Map<String, Resolver> resolverMap = new ConcurrentHashMap<String, Resolver>();

    public static String resolveString(String raw, ItemModule.ModuleInstance instance) {
        String resolved = raw;
        Pattern pattern = Pattern.compile("\\[([^\\[]*?)\\]");
        Matcher matcher = pattern.matcher(raw);
        int counter = 10;
        while (matcher.find() && counter > 0) {
            --counter;
            String match = matcher.group(1);
            String[] parts = match.split("\\.");
            if (parts.length >= 2) {
                String resolverKey = parts[0];
                String resolverData = String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length));
                Resolver resolver = resolverMap.get(resolverKey);
                if (resolver != null) {
                    String resolvedData = resolver.resolveString(resolverData, instance);
                    resolved = resolved.replace("[" + match + "]", resolvedData);
                } else {
                    resolved = resolved.replace("[" + match + "]", "");
                }
            } else {
                resolved = resolved.replace("[" + match + "]", "");
            }
            matcher = pattern.matcher(resolved);
        }
        return resolved;
    }

    public static double resolveDouble(JsonElement raw, ItemModule.ModuleInstance instance) {
        try {
            return raw.getAsDouble();
        }
        catch (Exception exception) {
            return StatResolver.resolveDouble(raw.getAsString(), instance);
        }
    }

    public static double resolveDouble(String raw, ItemModule.ModuleInstance instance) {
        try {
            return Double.parseDouble(raw);
        }
        catch (Exception exception) {
            String resolved = raw;
            Pattern pattern = Pattern.compile("\\[(.*?)\\]");
            Matcher matcher = pattern.matcher(raw);
            while (matcher.find()) {
                String match = matcher.group(1);
                String[] parts = match.split("\\.");
                if (parts.length < 2) continue;
                String resolverKey = parts[0];
                String resolverData = String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length));
                Resolver resolver = resolverMap.get(resolverKey);
                if (resolver != null) {
                    String resolvedData = String.valueOf(resolver.resolveDouble(resolverData, instance));
                    resolved = resolved.replace("[" + match + "]", resolvedData);
                    continue;
                }
                resolved = resolved.replace("[" + match + "]", "");
            }
            return StatResolver.resolveCalculation(resolved);
        }
    }

    public static Component translateAndResolve(String raw, ItemModule.ModuleInstance instance) {
        String old = "";
        String newString = raw;
        for (int i = 0; i < 100 && !old.equals(newString); ++i) {
            old = newString;
            newString = StatResolver.resolveString(old, instance);
            ArrayList translatedStrings = new ArrayList();
            Arrays.stream(newString.split(" ")).forEach(s -> translatedStrings.add(Component.m_237115_((String)s).getString()));
            newString = String.join((CharSequence)" ", translatedStrings);
        }
        return Component.m_237113_((String)newString);
    }

    public static void registerResolver(String keyWord, Resolver resolver) {
        resolverMap.put(keyWord, resolver);
    }

    public static double resolveCalculation(String string) {
        try {
            Expression e = new Expression(string, EvalExResolverStuff.configuration);
            return e.evaluate().getNumberValue().doubleValue();
        }
        catch (Exception e) {
            Miapi.LOGGER.error("could not evaluate " + string, (Throwable)e);
            return 0.0;
        }
    }

    static {
        StatResolver.registerResolver("translation", new Resolver(){

            @Override
            public double resolveDouble(String data, ItemModule.ModuleInstance instance) {
                return Double.parseDouble(Component.m_237115_((String)data).getString());
            }

            @Override
            public String resolveString(String data, ItemModule.ModuleInstance instance) {
                return Component.m_237115_((String)data).getString();
            }
        });
        StatResolver.registerResolver("collect", new Resolver(){

            @Override
            public double resolveDouble(String data, ItemModule.ModuleInstance instance) {
                if (data.contains(".")) {
                    String[] parts = data.split("\\.", 2);
                    Stream<Double> numbers = instance.getRoot().allSubModules().stream().map(module -> StatResolver.resolveDouble(parts[1], module));
                    double result = 0.0;
                    switch (parts[1]) {
                        case "add": {
                            result = numbers.collect(Collectors.summarizingDouble(Double::doubleValue)).getSum();
                            break;
                        }
                        case "max": {
                            result = numbers.collect(Collectors.summarizingDouble(Double::doubleValue)).getMax();
                            break;
                        }
                        case "min": {
                            result = numbers.collect(Collectors.summarizingDouble(Double::doubleValue)).getMin();
                            break;
                        }
                        case "average": {
                            result = numbers.collect(Collectors.averagingDouble(Double::doubleValue));
                            break;
                        }
                        default: {
                            Miapi.LOGGER.warn("invalid collect Operation " + parts[1] + " add, max, min, average are valid operations");
                        }
                    }
                    return result;
                }
                return 0.0;
            }

            @Override
            public String resolveString(String data, ItemModule.ModuleInstance instance) {
                return null;
            }
        });
        StatResolver.registerResolver("material-module", new Resolver(){

            @Override
            public double resolveDouble(String data, ItemModule.ModuleInstance instance) {
                double firstResult = StatResolver.resolveDouble("material." + data, instance);
                if (firstResult == 0.0) {
                    return StatResolver.resolveDouble("module." + data, instance);
                }
                return firstResult;
            }

            @Override
            public String resolveString(String data, ItemModule.ModuleInstance instance) {
                String firstResult = StatResolver.resolveString("material." + data, instance);
                if (firstResult == null || firstResult.isEmpty()) {
                    return StatResolver.resolveString("module." + data, instance);
                }
                return firstResult;
            }
        });
        StatResolver.registerResolver("module-material", new Resolver(){

            @Override
            public double resolveDouble(String data, ItemModule.ModuleInstance instance) {
                double firstResult = StatResolver.resolveDouble("module." + data, instance);
                if (firstResult == 0.0) {
                    return StatResolver.resolveDouble("material." + data, instance);
                }
                return firstResult;
            }

            @Override
            public String resolveString(String data, ItemModule.ModuleInstance instance) {
                String firstResult = StatResolver.resolveString("module." + data, instance);
                if (firstResult == null || firstResult.isEmpty()) {
                    return StatResolver.resolveString("material." + data, instance);
                }
                return firstResult;
            }
        });
        StatResolver.registerResolver("count", new Resolver(){

            @Override
            public double resolveDouble(String data, ItemModule.ModuleInstance instance) {
                double count = 0.0;
                switch (data) {
                    case "module": {
                        count = instance.getRoot().allSubModules().size();
                        break;
                    }
                    case "submodule": {
                        count = instance.allSubModules().size();
                        break;
                    }
                    case "unique_materials": {
                        count = instance.getRoot().allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).filter(Objects::nonNull).count();
                        break;
                    }
                    case "root_material_matches": {
                        Optional<Material> material = instance.getRoot().allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).findFirst();
                        if (!material.isPresent()) break;
                        count = instance.getRoot().allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).filter(m -> ((Material)material.get()).equals(m)).count();
                        break;
                    }
                    case "material_matches": {
                        Optional<Material> material = instance.allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).findFirst();
                        if (!material.isPresent()) break;
                        count = instance.getRoot().allSubModules().stream().filter(m -> MaterialProperty.getMaterial(m) != null).map(MaterialProperty::getMaterial).filter(m -> ((Material)material.get()).equals(m)).count();
                        break;
                    }
                    default: {
                        Miapi.LOGGER.warn("Statresolver count doesnt recognise " + data + " it only allows for module and submodules as keys");
                    }
                }
                return count;
            }

            @Override
            public String resolveString(String data, ItemModule.ModuleInstance instance) {
                return null;
            }
        });
    }

    public static interface Resolver {
        public double resolveDouble(String var1, ItemModule.ModuleInstance var2);

        public String resolveString(String var1, ItemModule.ModuleInstance var2);
    }

    @CodecBehavior.Override(value="fullCodec")
    public static class IntegerFromStat
    extends IntermediateCodec.Median<String, ItemModule.ModuleInstance, Integer> {
        public static BiFunction<String, ItemModule.ModuleInstance, Integer> func = (raw, input) -> (int)StatResolver.resolveDouble(raw, input);
        public static Codec<IntegerFromStat> codec = new CustomIntermediateCodec((Codec)Codec.STRING, func, (s, b) -> new IntegerFromStat((String)s));
        public static Codec<IntegerFromStat> fullCodec = Codec.either((Codec)Codec.INT, codec).xmap(either -> {
            if (either.right().isPresent()) {
                return (IntegerFromStat)((Object)((Object)either.right().get()));
            }
            return new IntegerFromStat((Integer)either.left().get());
        }, Either::right);

        public IntegerFromStat(String start) {
            super((Object)start, func);
        }

        public IntegerFromStat(int start) {
            this(String.valueOf(start));
        }

        public String toString() {
            return "IntegerFromStat{start=" + (String)this.start + "}";
        }
    }

    @CodecBehavior.Override(value="fullCodec")
    public static class DoubleFromStat
    extends IntermediateCodec.Median<String, ItemModule.ModuleInstance, Double> {
        public static BiFunction<String, ItemModule.ModuleInstance, Double> func = StatResolver::resolveDouble;
        public static Codec<DoubleFromStat> codec = new CustomIntermediateCodec((Codec)Codec.STRING, func, (s, b) -> new DoubleFromStat((String)s));
        public static Codec<DoubleFromStat> fullCodec = Codec.either((Codec)Codec.DOUBLE, codec).xmap(either -> {
            if (either.right().isPresent()) {
                return (DoubleFromStat)((Object)((Object)either.right().get()));
            }
            return new DoubleFromStat((Double)either.left().get());
        }, Either::right);

        public DoubleFromStat(String start) {
            super((Object)start, func);
        }

        public DoubleFromStat(double start) {
            this(String.valueOf(start));
        }

        public String toString() {
            return "DoubleFromStat{start=" + (String)this.start + "}";
        }
    }

    @CodecBehavior.Override(value="codec")
    public static class StringFromStat
    extends IntermediateCodec.Median<String, ItemModule.ModuleInstance, String> {
        public static BiFunction<String, ItemModule.ModuleInstance, String> func = StatResolver::resolveString;
        public static Codec<StringFromStat> codec = new CustomIntermediateCodec((Codec)Codec.STRING, func, (s, b) -> new StringFromStat((String)s));

        public StringFromStat(String start) {
            super((Object)start, func);
        }
    }

    public static final class Codecs {
        public static Codec<String> STRING(ItemModule.ModuleInstance instance) {
            return Codec.STRING.xmap(s -> StatResolver.resolveString(s, instance), s -> s);
        }

        public static Codec<Double> DOUBLE(ItemModule.ModuleInstance instance) {
            return Codec.either((Codec)Codec.DOUBLE, (Codec)Codec.STRING.xmap(s -> StatResolver.resolveDouble(s, instance), String::valueOf)).xmap(e -> {
                if (e.left().isPresent()) {
                    return (Double)e.left().get();
                }
                return (Double)e.right().get();
            }, Either::left);
        }

        public static Codec<Integer> INTEGER(ItemModule.ModuleInstance instance) {
            return Codec.either((Codec)Codec.INT, (Codec)Codecs.DOUBLE(instance).xmap(Double::intValue, Integer::doubleValue)).xmap(e -> {
                if (e.left().isPresent()) {
                    return (Integer)e.left().get();
                }
                return (Integer)e.right().get();
            }, Either::left);
        }
    }
}

