/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular;

import java.util.HashMap;
import java.util.Map;
import smartin.miapi.item.modular.Transform;

public class TransformMap {
    protected Map<String, Transform> stack = new HashMap<String, Transform>();
    public String primary = null;

    public Transform get(String id) {
        return this.stack.computeIfAbsent(id, key -> Transform.IDENTITY);
    }

    public Transform get() {
        return this.stack.computeIfAbsent(this.primary, key -> Transform.IDENTITY);
    }

    public static TransformMap merge(TransformMap parent, TransformMap toMerge) {
        TransformMap merged = parent.copy();
        toMerge.stack.forEach(merged::add);
        return merged;
    }

    public boolean isPresent(String id) {
        return this.stack.containsKey(id);
    }

    public void set(String id, Transform transform) {
        this.stack.put(id, transform);
    }

    public void add(String id, Transform transform) {
        Transform old = this.get(id);
        this.set(id, Transform.merge(old, transform));
    }

    public void add(Transform transform) {
        this.add(transform.origin, transform);
        if (transform.origin != null) {
            this.primary = transform.origin;
        }
    }

    public TransformMap copy() {
        TransformMap newStack = new TransformMap();
        this.stack.forEach((id, transform) -> newStack.add((String)id, transform.copy()));
        return newStack;
    }
}

