/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.model.ModularModelPredicateProvider;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.PlatformModularItemMethods;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.RarityProperty;
import smartin.miapi.modules.properties.RepairPriority;

public class ModularBow
extends BowItem
implements PlatformModularItemMethods,
ModularItem {
    public static Predicate<ItemStack> projectile = f_43005_;
    public static UUID bowMoveSpeedUUId = UUID.fromString("4de85d6c-7923-11ee-b962-0242ac120002");

    public ModularBow(Item.Properties settings) {
        super(settings.m_41487_(1).m_41503_(50));
        if (Environment.isClient()) {
            this.registerAnimations();
        }
    }

    public ModularBow() {
        super(new Item.Properties().m_41487_(1).m_41503_(50));
        if (Environment.isClient()) {
            this.registerAnimations();
        }
    }

    public boolean m_8120_(ItemStack itemStack) {
        return true;
    }

    public int m_6473_() {
        return 1;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)ModularItem.getDurability(stack));
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, ((float)ModularItem.getDurability(stack) - (float)stack.m_41773_()) / (float)ModularItem.getDurability(stack));
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return RepairPriority.getRepairValue(stack, ingredient) > 0.0;
    }

    public Rarity m_41460_(ItemStack stack) {
        return RarityProperty.getRarity(stack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
    }

    public void m_5551_(ItemStack bowStack, Level world, LivingEntity user, int remainingUseTicks) {
        float pullProgress;
        if (!(user instanceof Player)) {
            return;
        }
        Player playerEntity = (Player)user;
        boolean consumeArrow = !playerEntity.m_150110_().f_35937_;
        ItemStack projectileStack = playerEntity.m_6298_(bowStack);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)bowStack) > 0 && (projectileStack.m_41619_() || projectileStack.m_41720_() instanceof ArrowItem && projectileStack.m_41782_() && projectileStack.m_41784_().m_128456_()) && (projectileStack.m_41619_() || projectileStack.m_41720_() == Items.f_42412_)) {
            consumeArrow = false;
            projectileStack = new ItemStack((ItemLike)Items.f_42412_);
            projectileStack.m_41764_(1);
        }
        if (projectileStack.m_41619_() && consumeArrow && !MiapiConfig.INSTANCE.server.enchants.betterInfinity) {
            return;
        }
        if (projectileStack.m_41619_()) {
            projectileStack = new ItemStack((ItemLike)Items.f_42412_);
        }
        if ((double)(pullProgress = ModularBow.getPullProgress(bowStack.m_41720_().m_8105_(bowStack) - remainingUseTicks, bowStack)) < 0.1) {
            return;
        }
        ModularBow.shoot(bowStack, projectileStack, world, user, pullProgress, consumeArrow, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f);
        if (consumeArrow) {
            projectileStack.m_41774_(1);
            if (projectileStack.m_41619_()) {
                playerEntity.m_150109_().m_36057_(projectileStack);
            }
        }
    }

    public static void shoot(ItemStack bowStack, ItemStack projectileStack, Level world, LivingEntity user, float pullProgress, boolean canPickup, float pitch, float yaw, float roll) {
        Item item;
        if (!(user instanceof Player)) {
            return;
        }
        Player playerEntity = (Player)user;
        if (!world.f_46443_ && (item = projectileStack.m_41720_()) instanceof ArrowItem) {
            ArrowItem arrowItem = (ArrowItem)item;
            int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bowStack);
            int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bowStack);
            int piercingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)bowStack);
            ItemStack projectileStackConsumed = projectileStack.m_41777_();
            projectileStackConsumed.m_41764_(1);
            AbstractArrow itemProjectile = arrowItem.m_6394_(world, projectileStack, (LivingEntity)playerEntity);
            if (itemProjectile instanceof ItemProjectileEntity) {
                ItemProjectileEntity modularProjectile = (ItemProjectileEntity)itemProjectile;
                modularProjectile.setSpeedDamage(true);
            }
            itemProjectile.m_36767_((byte)((byte)AttributeProperty.getActualValue(projectileStack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_PIERCING) + piercingLevel));
            float divergence = (float)Math.pow(12.0, -AttributeProperty.getActualValue(bowStack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_ACCURACY));
            float speed = (float)Math.max(0.1, AttributeProperty.getActualValue(bowStack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_SPEED) + 3.0);
            float damage = (float)AttributeProperty.getActualValue(bowStack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_DAMAGE) / speed;
            itemProjectile.m_36781_((double)damage + itemProjectile.m_36789_());
            itemProjectile.m_37251_((Entity)playerEntity, pitch, yaw, roll, pullProgress * speed, divergence);
            if (pullProgress == 1.0f) {
                itemProjectile.m_36762_(true);
                itemProjectile.m_36792_();
            }
            if (powerLevel > 0) {
                itemProjectile.m_36781_(itemProjectile.m_36789_() + (double)powerLevel * 0.5 + 0.5);
            }
            if (punchLevel > 0) {
                itemProjectile.m_36735_(punchLevel);
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bowStack) > 0) {
                itemProjectile.m_20254_(100);
            }
            bowStack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(playerEntity.m_7655_()));
            itemProjectile.f_36705_ = !canPickup ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
            MiapiProjectileEvents.ModularBowShotEvent event = new MiapiProjectileEvents.ModularBowShotEvent(itemProjectile, bowStack, (LivingEntity)playerEntity);
            if (((MiapiProjectileEvents.ModularBowShot)MiapiProjectileEvents.MODULAR_BOW_SHOT.invoker()).call(event).interruptsFurtherEvaluation()) {
                return;
            }
            itemProjectile = event.projectile;
            world.m_7967_((Entity)itemProjectile);
            MiapiProjectileEvents.ModularBowShotEvent postEvent = new MiapiProjectileEvents.ModularBowShotEvent(itemProjectile, bowStack, (LivingEntity)playerEntity);
            postEvent.bowStack = bowStack;
            postEvent.shooter = playerEntity;
            postEvent.projectile = itemProjectile;
            if (((MiapiProjectileEvents.ModularBowShot)MiapiProjectileEvents.MODULAR_BOW_POST_SHOT.invoker()).call(postEvent).interruptsFurtherEvaluation()) {
                return;
            }
        }
        world.m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.m_213780_().m_188501_() * 0.4f + 1.2f) + pullProgress * 0.5f);
        playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)bowStack.m_41720_()));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (MiapiConfig.INSTANCE.server.enchants.betterInfinity) {
            ItemStack itemStack = user.m_21120_(hand);
            ItemStack projectileStack = user.m_6298_(itemStack);
            if (itemStack.m_41782_()) {
                CompoundTag compound = itemStack.m_41784_();
                compound = compound.m_128469_("BOW_PROJECTILE");
                projectileStack.m_41739_(compound);
            }
            boolean bl = !projectileStack.m_41619_();
            int infinityLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemStack);
            if (user.m_150110_().f_35937_ || bl || infinityLevel > 0) {
                user.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)itemStack);
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return super.m_7203_(world, user, hand);
    }

    public static float getPullProgress(int useTicks, ItemStack stack) {
        float f;
        if (useTicks < 1) {
            return 0.0f;
        }
        float f2 = (float)((double)useTicks / (20.0 - AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.BOW_DRAW_TIME)));
        f2 = (f2 * f2 + f2 * 2.0f) / 3.0f;
        if (f > 1.0f) {
            f2 = 1.0f;
        }
        return f2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerAnimations() {
        ModularModelPredicateProvider.registerModelOverride((Item)this, new ResourceLocation("pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return entity.m_21211_() != stack ? 0.0f : ModularBow.getPullProgress(stack.m_41779_() - entity.m_21212_(), stack);
        });
        ModularModelPredicateProvider.registerModelOverride((Item)this, new ResourceLocation("pulling"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    public Predicate<ItemStack> m_6437_() {
        return projectile;
    }

    public Component m_7626_(ItemStack stack) {
        return DisplayNameProperty.getDisplayText(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        LoreProperty.appendLoreTop(stack, world, tooltip, context);
    }
}

