/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.FakeEnchantment;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.properties.ChannelingProperty;
import smartin.miapi.modules.properties.EnchantAbilityProperty;

@Mixin(value={EnchantmentHelper.class}, priority=700)
public class EnchantmentHelperMixin {
    @Inject(method={"getPossibleEntries(ILnet/minecraft/item/ItemStack;Z)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void miapi$modifyAttributeModifiers(int power, ItemStack stack, boolean treasureAllowed, CallbackInfoReturnable<List<EnchantmentInstance>> cir) {
        if (stack.m_41720_() instanceof ModularItem) {
            ArrayList<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>();
            block0: for (Enchantment enchantment : BuiltInRegistries.f_256876_) {
                boolean acceptableItem;
                if (enchantment.m_6591_() && !treasureAllowed || !enchantment.m_6592_() || (acceptableItem = enchantment.m_6081_(stack))) continue;
                for (int level = enchantment.m_6586_(); level >= enchantment.m_44702_(); --level) {
                    int minPower = enchantment.m_6183_(level);
                    int maxPower = enchantment.m_6175_(level);
                    if (power < minPower || power > maxPower) continue;
                    enchantments.add(new EnchantmentInstance(enchantment, level));
                    continue block0;
                }
            }
            cir.setReturnValue(enchantments);
        }
    }

    @Inject(method={"hasChanneling(Lnet/minecraft/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void miapi$modifyChannelling(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.m_41720_() instanceof ModularItem && ChannelingProperty.hasChanneling(stack)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onTargetDamaged(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void miapi$addMagicDamage(LivingEntity attacker, Entity target, CallbackInfo ci) {
        if (target instanceof LivingEntity) {
            LivingEntity defender = (LivingEntity)target;
            ((MiapiEvents.LivingAttackEvent)MiapiEvents.LIVING_ATTACK.invoker()).attack(attacker, defender);
        }
    }

    @Inject(method={"generateEnchantments(Lnet/minecraft/util/math/random/Random;Lnet/minecraft/item/ItemStack;IZ)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void miapi$modifyGenerateEnchantments(RandomSource random, ItemStack stack, int level, boolean treasureAllowed, CallbackInfoReturnable<List<EnchantmentInstance>> cir) {
        if (stack.m_41720_() instanceof ModularItem) {
            ArrayList list = Lists.newArrayList();
            int i = (int)Math.ceil(EnchantAbilityProperty.getEnchantAbility(stack));
            if (i <= 0) {
                cir.setReturnValue((Object)list);
            }
            level += 1 + random.m_188503_(i / 4 + 1) + random.m_188503_(i / 4 + 1);
            float f = (random.m_188501_() + random.m_188501_() - 1.0f) * 0.15f;
            List<EnchantmentInstance> list2 = EnchantmentHelperMixin.getLevels(level = Mth.m_14045_((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), stack, treasureAllowed);
            if (!list2.isEmpty()) {
                WeightedRandom.m_216822_((RandomSource)random, list2).ifPresent(list::add);
                while (random.m_188503_(50) <= level) {
                    if (!list.isEmpty()) {
                        EnchantmentHelper.m_44862_(list2, (EnchantmentInstance)((EnchantmentInstance)Util.m_137509_((List)list)));
                    }
                    if (list2.isEmpty()) break;
                    WeightedRandom.m_216822_((RandomSource)random, list2).ifPresent(list::add);
                    level /= 2;
                }
            }
            cir.setReturnValue((Object)list);
        }
    }

    @Inject(method={"getPossibleEntries(ILnet/minecraft/item/ItemStack;Z)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void miapi$modifyPossibleEntries(int power, ItemStack stack, boolean treasureAllowed, CallbackInfoReturnable<List<EnchantmentInstance>> cir) {
        if (stack.m_41720_() instanceof ModularItem) {
            ArrayList list = Lists.newArrayList();
            for (Enchantment enchantment : BuiltInRegistries.f_256876_) {
                if (enchantment.m_6591_() && (!enchantment.m_6591_() || !treasureAllowed) || !enchantment.m_6592_() || !enchantment.m_6081_(stack)) continue;
                for (int i = enchantment.m_6586_(); i > enchantment.m_44702_() - 1; --i) {
                    if (power < enchantment.m_6183_(i) || power > enchantment.m_6175_(i)) continue;
                    list.add(new EnchantmentInstance(enchantment, i));
                }
            }
            cir.setReturnValue((Object)list);
        }
    }

    @Inject(method={"getLevel(Lnet/minecraft/enchantment/Enchantment;Lnet/minecraft/item/ItemStack;)I"}, at={@At(value="RETURN")}, cancellable=true)
    private static void miapi$modifyPossibleEntries(Enchantment enchantment, ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        if (stack.m_41720_() instanceof ModularItem) {
            cir.setReturnValue((Object)FakeEnchantment.getFakeLevel(enchantment, stack, (Integer)cir.getReturnValue()));
        }
    }

    private static List<EnchantmentInstance> getLevels(int power, ItemStack stack, boolean treasureAllowed) {
        ArrayList list = Lists.newArrayList();
        if (stack.m_41720_() instanceof ModularItem) {
            for (Enchantment enchantment : BuiltInRegistries.f_256876_) {
                if (enchantment.m_6591_() && (!enchantment.m_6591_() || !treasureAllowed) || !enchantment.m_6592_() || !enchantment.m_6081_(stack)) continue;
                for (int i = enchantment.m_6586_(); i > enchantment.m_44702_() - 1; --i) {
                    if (power < enchantment.m_6183_(i) || power > enchantment.m_6175_(i)) continue;
                    list.add(new EnchantmentInstance(enchantment, i));
                }
            }
        }
        return list;
    }

    @Inject(method={"forEachEnchantment(Lnet/minecraft/enchantment/EnchantmentHelper$Consumer;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="TAIL")}, cancellable=true)
    private static void miapi$addFakeEnchants(EnchantmentHelper.EnchantmentVisitor consumer, ItemStack stack, CallbackInfo ci) {
        FakeEnchantment.addEnchantments(consumer, stack);
    }
}

