/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.item.modular.items.ModularSetableToolMaterial;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.FakeItemTagProperty;
import smartin.miapi.modules.properties.HideFlagsProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;
import smartin.miapi.registries.RegistryInventory;

@Mixin(value={ItemStack.class}, priority=2000)
abstract class ItemStackMixin {
    ItemStackMixin() {
    }

    @Inject(method={"getHideFlags()I"}, at={@At(value="TAIL")}, cancellable=true)
    private void miapi$adjustGetHideFlags(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        cir.setReturnValue((Object)HideFlagsProperty.getHideProperty((Integer)cir.getReturnValue(), stack));
    }

    @Inject(method={"setNbt(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void miapi$cacheMaintanaince(CompoundTag nbt, CallbackInfo ci) {
        ItemStack stack = (ItemStack)this;
        ModularItemCache.clearUUIDFor(stack);
    }

    @Inject(method={"setNbt(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void miapi$cacheMaintanaince2(CompoundTag nbt, CallbackInfo ci) {
        ItemStack stack = (ItemStack)this;
        ModularItemCache.clearUUIDFor(stack);
    }

    @Inject(method={"getItem"}, at={@At(value="RETURN")})
    private void miapi$getItemCallback(CallbackInfoReturnable<Item> cir) {
        ItemStack stack = (ItemStack)this;
        Object object = cir.getReturnValue();
        if (object instanceof ModularSetableToolMaterial) {
            ModularSetableToolMaterial toolMaterial = (ModularSetableToolMaterial)object;
            toolMaterial.setToolMaterial(stack);
        }
    }

    @Inject(method={"getMaxDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void miapi$modifyDurability(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        if (stack.m_41720_() instanceof VisualModularItem) {
            cir.setReturnValue((Object)ModularItem.getDurability(stack));
        }
    }

    @Inject(method={"isSuitableFor(Lnet/minecraft/block/BlockState;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void miapi$injectIsSuitable(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = (ItemStack)this;
        if (stack.m_41720_() instanceof ModularItem) {
            cir.setReturnValue((Object)MiningLevelProperty.isSuitable(stack, state));
        }
    }

    @Inject(method={"getTooltip(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/client/item/TooltipContext;)Ljava/util/List;"}, slice={@Slice(from=@At(value="HEAD"), to=@At(value="INVOKE", target="Lnet/minecraft/client/item/TooltipContext;isAdvanced()Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/item/TooltipContext;isAdvanced()Z", shift=At.Shift.BEFORE, by=1)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void miapi$injectLoreTop(Player player, TooltipFlag context, CallbackInfoReturnable<List<Component>> cir, List<Component> arg1) {
        ItemStack stack = (ItemStack)this;
        if (!(stack.m_41720_() instanceof ModularItem)) {
            LoreProperty.property.injectTooltipOnNonModularItems(arg1, stack);
        }
    }

    @Inject(method={"getTooltip(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/client/item/TooltipContext;)Ljava/util/List;"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/item/TooltipContext;isAdvanced()Z"), to=@At(value="RETURN"))}, at={@At(value="INVOKE", target="Lnet/minecraft/client/item/TooltipContext;isAdvanced()Z", shift=At.Shift.BEFORE, by=-1)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void miapi$injectLoreBottom(Player player, TooltipFlag context, CallbackInfoReturnable<List<Component>> cir, List<Component> arg1) {
        ItemStack stack = (ItemStack)this;
        PreviewManager.setCursorItemstack(stack);
        LoreProperty.property.appendLoreBottom(arg1, stack);
    }

    @Inject(method={"isIn"}, at={@At(value="TAIL")}, cancellable=true)
    public void miapi$injectItemTag(TagKey<Item> tag, CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = (ItemStack)this;
        if (stack.m_41720_() instanceof ModularItem && !((Boolean)cir.getReturnValue()).booleanValue()) {
            cir.setReturnValue((Object)FakeItemTagProperty.hasTag(tag.f_203868_(), stack));
        }
    }

    @Inject(method={"damage(ILnet/minecraft/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends LivingEntity> void miapi$takeDurabilityDamage(int amount, T entity, Consumer<T> breakCallback, CallbackInfo ci) {
        ItemStack stack = (ItemStack)this;
        if (!MiapiConfig.INSTANCE.server.other.fullBreakModularItems && stack.m_41720_() instanceof VisualModularItem && stack.m_41763_() && stack.m_41773_() + amount + 1 >= stack.m_41776_()) {
            for (EquipmentSlot value : EquipmentSlot.values()) {
                if (!entity.m_6844_(value).equals(stack)) continue;
                ItemStack brokenStack = new ItemStack((ItemLike)RegistryInventory.visualOnlymodularItem);
                brokenStack.m_41751_(stack.m_41783_());
                entity.m_8061_(value, brokenStack);
                ci.cancel();
            }
        }
    }
}

