/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.mixin;

import java.util.Map;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.attributes.ElytraAttributes;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.properties.EquipmentSlotProperty;
import smartin.miapi.registries.RegistryInventory;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin {
    @Shadow
    @Final
    public WalkAnimationState f_267362_;

    LivingEntityMixin() {
    }

    @Inject(method={"getPreferredEquipmentSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private static void miapi$onGetPreferredEquipmentSlot(ItemStack stack, CallbackInfoReturnable<EquipmentSlot> cir) {
        EquipmentSlot slot;
        if (stack.m_41720_() instanceof ModularItem && (slot = EquipmentSlotProperty.getSlot(stack)) != null) {
            cir.setReturnValue((Object)slot);
        }
    }

    @Inject(method={"Lnet/minecraft/entity/LivingEntity;getEquipmentChanges()Ljava/util/Map;"}, at={@At(value="RETURN")})
    private void miapi$enEquipChange(CallbackInfoReturnable<Map<EquipmentSlot, ItemStack>> cir) {
        LivingEntity player = (LivingEntity)this;
        if (player instanceof Player) {
            Player entity = (Player)player;
            Map map = (Map)cir.getReturnValue();
            if (map != null && !map.isEmpty()) {
                ((MiapiEvents.PlayerEquip)MiapiEvents.PLAYER_EQUIP_EVENT.invoker()).equip(entity, map);
            }
        }
    }

    @Inject(method={"teleport(DDDZ)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void miapi$optionalTeleportBlockEffect(double x, double y, double z, boolean particleEffects, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (particleEffects && MiapiConfig.INSTANCE.server.other.blockAllTeleportsEffect && entity.m_21023_(RegistryInventory.teleportBlockEffect)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="TAIL")}, cancellable=true)
    private static void miapi$addAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        AttributeSupplier.Builder builder = (AttributeSupplier.Builder)cir.getReturnValue();
        if (builder != null) {
            AttributeRegistry.entityAttributeMap.forEach((id, attribute) -> builder.m_22266_(attribute));
            ((MiapiEvents.LivingEntityAttributeBuild)MiapiEvents.LIVING_ENTITY_ATTRIBUTE_BUILD_EVENT.invoker()).build(builder);
        }
    }

    @Inject(method={"Lnet/minecraft/entity/LivingEntity;tick()V"}, at={@At(value="TAIL")}, cancellable=true)
    private void miapi$tickShieldingArmor(CallbackInfo ci) {
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void miapi$adjustElytraSpeed(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        ElytraAttributes.movementUpdate(livingEntity);
        ((MiapiEvents.LivingEntityTickEvent)MiapiEvents.LIVING_ENTITY_TICK_END.invoker()).tick(livingEntity);
    }

    @Inject(method={"tickMovement()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void miapi$stopMovementTick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity.m_21023_(RegistryInventory.stunEffect)) {
            if (livingEntity instanceof Player) {
                Player playerEntity = (Player)livingEntity;
                if (!playerEntity.m_21023_(MobEffects.f_19610_)) {
                    // empty if block
                }
            } else {
                ci.cancel();
            }
        }
    }
}

