/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class ItemModule {
    public static final MiapiRegistry<ItemModule> moduleRegistry = MiapiRegistry.getInstance(ItemModule.class);
    private final String name;
    private final Map<String, JsonElement> properties;
    public static final String MODULE_KEY = "modules";
    public static final String NBT_MODULE_KEY = "miapi_modules";
    public static final String PROPERTY_KEY = "rawProperties";
    public static final ItemModule empty = new ItemModule("empty", new HashMap<String, JsonElement>());
    public static final ItemModule internal = new ItemModule("internal", new HashMap<String, JsonElement>());

    public ItemModule(String name, Map<String, JsonElement> properties) {
        this.name = name;
        this.properties = properties;
    }

    public Map<String, JsonElement> getProperties() {
        return this.properties;
    }

    public Map<ModuleProperty, JsonElement> getKeyedProperties() {
        HashMap<ModuleProperty, JsonElement> map = new HashMap<ModuleProperty, JsonElement>();
        this.getProperties().forEach((key, jsonData) -> map.put(RegistryInventory.moduleProperties.get((String)key), (JsonElement)jsonData));
        return map;
    }

    public String getName() {
        return this.name;
    }

    public static void loadFromData(String path, String moduleJsonString, boolean isClient) {
        try {
            JsonObject moduleJson = (JsonObject)Miapi.gson.fromJson(moduleJsonString, JsonObject.class);
            if (!path.startsWith(MODULE_KEY)) {
                return;
            }
            Type type = new TypeToken<Map<String, JsonElement>>(){}.getType();
            String name = moduleJson.get("name").getAsString();
            HashMap<String, JsonElement> moduleProperties = new HashMap<String, JsonElement>();
            Map rawProperties = (Map)Miapi.gson.fromJson(moduleJsonString, type);
            rawProperties.forEach((key, json) -> {
                if (ItemModule.isValidProperty(key, path, json, isClient)) {
                    moduleProperties.put((String)key, (JsonElement)json);
                }
            });
            moduleRegistry.register(name, new ItemModule(name, moduleProperties));
        }
        catch (Exception e) {
            Miapi.LOGGER.warn("Could not load Module " + path, (Throwable)e);
        }
    }

    public static void loadModuleExtension(String path, String moduleJsonString, boolean isClient) {
        try {
            JsonObject moduleJson = (JsonObject)Miapi.gson.fromJson(moduleJsonString, JsonObject.class);
            String name = moduleJson.get("name").getAsString();
            ItemModule module = moduleRegistry.get(name);
            if (module == null) {
                Miapi.LOGGER.warn("module not found to be extended! " + name);
                return;
            }
            HashMap<String, JsonElement> moduleProperties = new HashMap<String, JsonElement>(module.getProperties());
            if (moduleJson.has("remove")) {
                moduleJson.get("remove").getAsJsonArray().forEach(jsonElement -> {
                    try {
                        moduleProperties.remove(jsonElement.getAsString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            if (moduleJson.has("merge")) {
                Map<String, JsonElement> rawMergeProperties = ItemModule.getPropertiesFromJsonString(moduleJson.get("merge"), path, isClient);
                rawMergeProperties.forEach((key, element) -> {
                    if (moduleProperties.containsKey(key)) {
                        ModuleProperty property = RegistryInventory.moduleProperties.get((String)key);
                        if (property != null) {
                            moduleProperties.put((String)key, property.merge((JsonElement)moduleProperties.get(key), (JsonElement)element, MergeType.SMART));
                        }
                    } else {
                        moduleProperties.put((String)key, (JsonElement)element);
                    }
                });
            }
            if (moduleJson.has("replace")) {
                Map<String, JsonElement> rawReplaceProperties = ItemModule.getPropertiesFromJsonString(moduleJson.get("replace"), path, isClient);
                moduleProperties.putAll(rawReplaceProperties);
            }
            moduleRegistry.getFlatMap().remove(name);
            moduleRegistry.register(name, new ItemModule(name, moduleProperties));
        }
        catch (Exception e) {
            Miapi.LOGGER.warn("Could not load Module to extend " + path, (Throwable)e);
        }
    }

    protected static Map<String, JsonElement> getPropertiesFromJsonString(String jsonString, String debugPath, boolean isClient) {
        HashMap<String, JsonElement> moduleProperties = new HashMap<String, JsonElement>();
        Type type = new TypeToken<Map<String, JsonElement>>(){}.getType();
        Map rawProperties = (Map)Miapi.gson.fromJson(jsonString, type);
        rawProperties.forEach((key, json) -> {
            if (ItemModule.isValidProperty(key, debugPath, json, isClient)) {
                moduleProperties.put((String)key, (JsonElement)json);
            }
        });
        return moduleProperties;
    }

    protected static Map<String, JsonElement> getPropertiesFromJsonString(JsonElement jsonString, String debugPath, boolean isClient) {
        HashMap<String, JsonElement> moduleProperties = new HashMap<String, JsonElement>();
        Type type = new TypeToken<Map<String, JsonElement>>(){}.getType();
        Map rawProperties = (Map)Miapi.gson.fromJson(jsonString, type);
        rawProperties.forEach((key, json) -> {
            if (ItemModule.isValidProperty(key, debugPath, json, isClient)) {
                moduleProperties.put((String)key, (JsonElement)json);
            }
        });
        return moduleProperties;
    }

    protected static void processModuleJsonElement(JsonElement element, Map<String, JsonElement> moduleProperties, String name, String path, String rawString, boolean isClient) {
        if (element.isJsonObject()) {
            JsonObject jsonObject = element.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                ModuleProperty property = RegistryInventory.moduleProperties.get(key);
                if (property != null) {
                    if (!ItemModule.isValidProperty(key, name, value, isClient)) continue;
                    moduleProperties.put(key, value);
                    continue;
                }
                if (value.isJsonObject()) {
                    ItemModule.processModuleJsonElement(value, moduleProperties, name, path, rawString, isClient);
                    continue;
                }
                if (value.isJsonArray()) {
                    JsonArray jsonArray = value.getAsJsonArray();
                    for (JsonElement jsonElement : jsonArray) {
                        ItemModule.processModuleJsonElement(jsonElement, moduleProperties, name, path, rawString, isClient);
                    }
                    continue;
                }
                Miapi.LOGGER.error("Error while reading ModuleJson, module " + name + " key/property " + key + " in file " + path + " Please make sure there are no Typos in the Property Names");
            }
        }
    }

    protected static boolean isValidProperty(String key, String moduleKey, JsonElement data, boolean isClient) {
        ModuleProperty property = RegistryInventory.moduleProperties.get(key);
        if (property != null) {
            try {
                return property.load(moduleKey, data);
            }
            catch (Exception e) {
                RuntimeException exception = new RuntimeException("Failure during moduleLoad, Error in Module " + moduleKey + " with property " + key + " with data " + data + " with error " + e.getLocalizedMessage());
                exception.addSuppressed(e);
                throw exception;
            }
        }
        Miapi.LOGGER.error("Module " + moduleKey + " contains invalid property " + key);
        Miapi.LOGGER.error("This indicates either a broken Module, Outdated API version or missing dependency!");
        return false;
    }

    public static ModuleInstance getModules(ItemStack stack) {
        if (ReloadEvents.isInReload()) {
            if (MiapiConfig.INSTANCE.server.other.verboseLogging) {
                // empty if block
            }
            return new ModuleInstance(new ItemModule("empty", new HashMap<String, JsonElement>()));
        }
        if (stack.m_41720_() instanceof VisualModularItem && !ReloadEvents.isInReload() && (stack.m_41784_().m_128423_(MODULE_KEY) != null || stack.m_41784_().m_128423_(NBT_MODULE_KEY) != null)) {
            ModuleInstance moduleInstance = (ModuleInstance)ModularItemCache.getRaw(stack, MODULE_KEY);
            if (moduleInstance == null || moduleInstance.module == null) {
                IllegalArgumentException exception = new IllegalArgumentException("Item has Invalid Module onReload - treating it like it has no modules");
                Miapi.LOGGER.warn("Item has Invalid Module onReload - treating it like it has no modules", (Throwable)exception);
                return new ModuleInstance(new ItemModule("empty", new HashMap<String, JsonElement>()));
            }
            return moduleInstance;
        }
        return new ModuleInstance(new ItemModule("empty", new HashMap<String, JsonElement>()));
    }

    public static Map<ItemModule, List<JsonElement>> getUnmergedProperties(ModuleInstance modules) {
        HashMap<ItemModule, List<JsonElement>> unmergedProperties = new HashMap<ItemModule, List<JsonElement>>();
        for (ModuleInstance module : modules.subModules.values()) {
            module.getProperties().forEach((property, data) -> ((List)unmergedProperties.getOrDefault(property, new ArrayList())).add(data));
        }
        return unmergedProperties;
    }

    public static JsonElement getMergedProperty(ModuleInstance moduleInstance, ModuleProperty property) {
        return ItemModule.getMergedProperty(moduleInstance, property, MergeType.SMART);
    }

    public static JsonElement getMergedProperty(ItemStack itemStack, ModuleProperty property) {
        return ItemModule.getMergedProperty(ItemModule.getModules(itemStack), property, MergeType.SMART);
    }

    public static JsonElement getMergedProperty(ModuleInstance moduleInstance, ModuleProperty property, MergeType type) {
        JsonElement mergedProperty = null;
        for (ModuleInstance module : moduleInstance.allSubModules()) {
            JsonElement currentProperty = module.getProperties().get(property);
            if (currentProperty == null) continue;
            if (mergedProperty == null) {
                mergedProperty = currentProperty;
                continue;
            }
            mergedProperty = property.merge(mergedProperty, currentProperty, type);
        }
        return mergedProperty;
    }

    public static JsonElement getMergedProperty(ItemStack itemStack, ModuleProperty property, MergeType type) {
        ModuleInstance moduleInstance = ItemModule.getModules(itemStack);
        JsonElement mergedProperty = null;
        for (ModuleInstance module : moduleInstance.allSubModules()) {
            JsonElement currentProperty = module.getProperties().get(property);
            if (currentProperty == null) continue;
            if (mergedProperty == null) {
                mergedProperty = currentProperty;
                continue;
            }
            mergedProperty = property.merge(mergedProperty, currentProperty, type);
        }
        return mergedProperty;
    }

    public static List<ModuleInstance> createFlatList(ModuleInstance root) {
        ArrayList<ModuleInstance> flatList = new ArrayList<ModuleInstance>();
        ArrayList<ModuleInstance> queue = new ArrayList<ModuleInstance>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ModuleInstance module = (ModuleInstance)queue.remove(0);
            if (module == null) continue;
            flatList.add(module);
            ArrayList submodules = new ArrayList();
            module.subModules.keySet().stream().sorted((a, b) -> b - a).forEach(id -> submodules.add(module.subModules.get(id)));
            queue.addAll(0, submodules);
        }
        return flatList;
    }

    public boolean isEmpty() {
        return this.equals(empty);
    }

    public boolean equals(Object other) {
        if (other instanceof ItemModule) {
            ItemModule otherModule = (ItemModule)other;
            return this.name.equals(otherModule.name);
        }
        return false;
    }

    @JsonAdapter(value=ModuleInstanceJsonAdapter.class)
    public static class ModuleInstance {
        public ItemModule module;
        @Nullable
        public ModuleInstance parent;
        public Map<Integer, ModuleInstance> subModules = new HashMap<Integer, ModuleInstance>();
        public Map<String, String> moduleData = new HashMap<String, String>();
        @Nullable
        public Map<ModuleProperty, JsonElement> rawProperties;

        public ModuleInstance(ItemModule module) {
            this.module = module;
        }

        public List<ModuleInstance> allSubModules() {
            return ItemModule.createFlatList(this);
        }

        public Map<ModuleProperty, JsonElement> getProperties() {
            if (this.rawProperties == null) {
                PropertyResolver.resolve(this.getRoot());
            }
            return this.rawProperties;
        }

        public Map<String, JsonElement> getKeyedProperties() {
            HashMap<String, JsonElement> map = new HashMap<String, JsonElement>();
            this.getProperties().forEach((property, jsonElement) -> map.put(RegistryInventory.moduleProperties.findKey((ModuleProperty)property), (JsonElement)jsonElement));
            return map;
        }

        public Map<ModuleProperty, JsonElement> getPropertiesMerged() {
            ConcurrentHashMap<ModuleProperty, JsonElement> map = new ConcurrentHashMap<ModuleProperty, JsonElement>();
            for (ModuleInstance moduleInstance : this.allSubModules()) {
                moduleInstance.getProperties().forEach((property, element) -> {
                    if (map.containsKey(property)) {
                        try {
                            map.put((ModuleProperty)property, property.merge((JsonElement)map.get(property), (JsonElement)element, MergeType.SMART));
                        }
                        catch (Exception e) {
                            Miapi.LOGGER.error("coudlnt merge " + property, (Throwable)e);
                            map.put((ModuleProperty)property, (JsonElement)element);
                        }
                    } else {
                        map.put((ModuleProperty)property, (JsonElement)element);
                    }
                });
            }
            return map;
        }

        public ModuleInstance getRoot() {
            ModuleInstance root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            return root;
        }

        public ModuleInstance copy() {
            ArrayList<Integer> position = new ArrayList<Integer>();
            this.calculatePosition(position);
            ModuleInstance root = this.getRoot().deepCopy();
            return root.getPosition(position);
        }

        public void calculatePosition(List<Integer> position) {
            if (this.parent != null) {
                this.parent.calculatePosition(position);
                position.add(this.getId());
            }
        }

        public ModuleInstance getPosition(List<Integer> position) {
            int pos;
            ModuleInstance subModule;
            if (!position.isEmpty() && (subModule = this.subModules.get(pos = position.remove(0).intValue())) != null) {
                return subModule.getPosition(position);
            }
            return this;
        }

        @Nullable
        public Integer getId() {
            if (this.parent != null) {
                for (Map.Entry<Integer, ModuleInstance> entry : this.parent.subModules.entrySet()) {
                    if (entry.getValue() != this) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        private ModuleInstance deepCopy() {
            ModuleInstance copy = new ModuleInstance(this.module);
            copy.moduleData = new HashMap<String, String>(this.moduleData);
            this.subModules.forEach((id, subModule) -> {
                ModuleInstance subModuleCopy = subModule.deepCopy();
                subModuleCopy.parent = copy;
                copy.subModules.put((Integer)id, subModuleCopy);
            });
            return copy;
        }

        public void writeToItem(ItemStack stack) {
            this.writeToItem(stack, true);
        }

        public void writeToItem(ItemStack stack, boolean clearCache) {
            if (clearCache) {
                ModularItemCache.clearUUIDFor(stack);
            }
            stack.m_41784_().m_128359_(ItemModule.NBT_MODULE_KEY, this.toString());
            if (stack.m_41784_().m_128441_(ItemModule.MODULE_KEY)) {
                // empty if block
            }
            stack.m_41784_().m_128359_(ItemModule.MODULE_KEY, this.toString());
            if (clearCache) {
                ModularItemCache.clearUUIDFor(stack);
            }
        }

        public String toString() {
            Gson gson = new Gson();
            return gson.toJson((Object)this);
        }

        public static ModuleInstance fromString(String string) {
            Gson gson = new Gson();
            ModuleInstance moduleInstance = (ModuleInstance)gson.fromJson(string, ModuleInstance.class);
            if (moduleInstance.module == null) {
                moduleInstance.module = empty;
            }
            return moduleInstance;
        }

        @Nullable
        public ModuleInstance parseTo(String[] data) {
            if (data.length == 0) {
                return this;
            }
            String[] newArray = Arrays.copyOfRange(data, 1, data.length);
            if ("parent".equals(data[0])) {
                if (this.parent != null) {
                    return this.parent.parseTo(newArray);
                }
            } else {
                try {
                    int id = Integer.parseInt(data[0]);
                    if (this.subModules.containsKey(id)) {
                        this.subModules.get(0).parseTo(newArray);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class ModuleInstanceJsonAdapter
    extends TypeAdapter<ModuleInstance> {
        public void write(JsonWriter out, ModuleInstance value) throws IOException {
            out.beginObject();
            out.name("module").value(value.module.name);
            if (value.moduleData != null) {
                out.name("moduleData").jsonValue(Miapi.gson.toJson(value.moduleData));
            } else {
                HashMap moduleData = new HashMap();
                out.name("moduleData").jsonValue(Miapi.gson.toJson(moduleData));
            }
            if (value.subModules != null) {
                out.name("subModules").jsonValue(Miapi.gson.toJson(value.subModules));
            } else {
                HashMap subModules = new HashMap();
                out.name("subModules").jsonValue(Miapi.gson.toJson(subModules));
            }
            out.endObject();
        }

        public ModuleInstance read(JsonReader in) throws IOException {
            JsonObject jsonObject = JsonParser.parseReader((JsonReader)in).getAsJsonObject();
            String moduleKey = jsonObject.get("module").getAsString();
            ItemModule module = moduleRegistry.get(moduleKey);
            if (module == null) {
                Miapi.LOGGER.warn("Module not found for " + moduleKey + " Key - substituting with empty module");
                module = empty;
            }
            ModuleInstance moduleInstance = new ModuleInstance(module);
            moduleInstance.subModules = (Map)Miapi.gson.fromJson(jsonObject.get("subModules"), new TypeToken<Map<Integer, ModuleInstance>>(){}.getType());
            if (moduleInstance.subModules != null) {
                moduleInstance.subModules.forEach((key, subModule) -> {
                    subModule.parent = moduleInstance;
                });
            } else {
                moduleInstance.subModules = new HashMap<Integer, ModuleInstance>();
            }
            moduleInstance.moduleData = (Map)Miapi.gson.fromJson(jsonObject.get("moduleData"), new TypeToken<Map<String, String>>(){}.getType());
            if (moduleInstance.moduleData == null) {
                moduleInstance.moduleData = new HashMap<String, String>();
            }
            return moduleInstance;
        }
    }
}

