/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.entity.BoomerangItemProjectileEntity;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.abilities.ThrowingAbility;
import smartin.miapi.modules.properties.AttributeProperty;

public class BoomerangThrowingAbility
extends ThrowingAbility {
    public static boolean isHolding = false;
    public static LinkedHashSet<Entity> entities = new LinkedHashSet();

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        user.m_6672_(hand);
        this.start();
        return InteractionResultHolder.m_19096_((Object)user.m_21120_(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Stream<Entity> getLookingEntity(Player player, double range, float deltaTick, double angleFilter) {
        List foundEntites = player.m_9236_().m_45933_((Entity)player, AABB.m_82333_((Vec3)player.m_20182_()).m_82400_(range));
        return foundEntites.stream().filter(target -> BoomerangThrowingAbility.isEntityLookedAtByPlayer(player, target, deltaTick, angleFilter)).sorted(Comparator.comparing(a -> (int)a.m_20270_((Entity)player)));
    }

    public static boolean isEntityLookedAtByPlayer(Player player, Entity target, float deltaTick, double angleFilter) {
        Vec3 vec3d = player.m_20252_(deltaTick).m_82541_();
        Vec3 vec3d2 = new Vec3(target.m_20185_() - player.m_20185_(), target.m_20188_() - player.m_20188_(), target.m_20189_() - player.m_20189_());
        double d = vec3d2.m_82553_();
        double e = vec3d.m_82526_(vec3d2 = vec3d2.m_82541_());
        return e > 1.0 - angleFilter / d && player.m_142582_(target);
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = this.getMaxUseTime(stack) - remainingUseTicks;
            if (i >= 10) {
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                if (!world.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(user.m_7655_()));
                    BoomerangItemProjectileEntity boomerangEntity = new BoomerangItemProjectileEntity(world, (LivingEntity)playerEntity, stack);
                    boomerangEntity.setTargets(entities);
                    float divergence = (float)AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_ACCURACY);
                    float speed = (float)AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_SPEED);
                    float damage = (float)AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_DAMAGE);
                    damage /= speed;
                    if (stack.m_41720_() instanceof ModularItem) {
                        speed = 0.5f;
                    }
                    boomerangEntity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, speed, divergence);
                    boomerangEntity.m_36781_(damage);
                    boomerangEntity.setBowItem(ItemStack.f_41583_);
                    boomerangEntity.m_36767_((byte)AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_PIERCING));
                    boomerangEntity.setSpeedDamage(true);
                    boomerangEntity.setPreferredSlot(playerEntity.m_150109_().f_35977_);
                    boomerangEntity.thrownStack = stack;
                    world.m_7967_((Entity)boomerangEntity);
                    world.m_6269_(null, (Entity)user, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (playerEntity.m_150110_().f_35937_) {
                        boomerangEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else {
                        user.m_21008_(user.m_7655_(), ItemStack.f_41583_);
                    }
                }
            }
        }
    }

    @Override
    public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user) {
        return super.finishUsing(stack, world, user);
    }

    @Override
    public void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        super.onStoppedUsing(stack, world, user, remainingUseTicks);
    }

    @Override
    public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user) {
        super.onStoppedHolding(stack, world, user);
    }

    public void start() {
        isHolding = true;
    }

    public void stop() {
        isHolding = false;
    }
}

