/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.RiptideProperty;

public class RiptideAbility
implements ItemUseDefaultCooldownAbility,
ItemUseMinHoldAbility {
    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        boolean missingLava;
        RiptideProperty.RiptideJson json = RiptideProperty.getData(itemStack);
        if (json == null) {
            return false;
        }
        boolean missingWater = !player.m_20070_();
        boolean bl = missingLava = json.allowLava && !player.m_20077_();
        if (json.needsWater && missingWater && missingLava) {
            return false;
        }
        return !json.needRiptideEnchant || EnchantmentHelper.m_44932_((ItemStack)itemStack) > 0;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getMaxUseTime(ItemStack itemStack) {
        return 7200;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (EnchantmentHelper.m_44932_((ItemStack)itemStack) > 0 && !user.m_20070_()) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @Override
    public int minHoldTimeDefault() {
        return 10;
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = this.getMaxUseTime(stack) - remainingUseTicks;
            if (i >= 10) {
                int j = EnchantmentHelper.m_44932_((ItemStack)stack);
                RiptideProperty.RiptideJson json = RiptideProperty.getData(stack);
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                float f = playerEntity.m_146908_();
                float g = playerEntity.m_146909_();
                float h = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
                float k = -Mth.m_14031_((float)(g * ((float)Math.PI / 180)));
                float l = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
                float m = Mth.m_14116_((float)(h * h + k * k + l * l));
                float n = (float)(json.riptideStrength * (double)((1.0f + (float)j) / 4.0f));
                playerEntity.m_5997_((double)(h *= n / m), (double)(k *= n / m), (double)(l *= n / m));
                playerEntity.m_204079_(20);
                if (playerEntity.m_20096_()) {
                    playerEntity.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                }
                SoundEvent soundEvent = j >= 3 ? SoundEvents.f_12519_ : (j == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                world.m_6269_((Player)null, (Entity)playerEntity, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

