/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.AbilityMangerProperty;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.LoreProperty;

public class ThrowingAbility
implements ItemUseDefaultCooldownAbility,
ItemUseMinHoldAbility {
    public ThrowingAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<MutableComponent> texts = new ArrayList<MutableComponent>();
            if (AbilityMangerProperty.isPrimaryAbility(this, itemStack)) {
                texts.add(Component.m_237115_((String)"miapi.ability.throw.lore"));
            }
            return texts;
        });
    }

    @Override
    public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.SPEAR;
    }

    @Override
    public int getMaxUseTime(ItemStack stack) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)user.m_21120_(hand));
    }

    @Override
    public int minHoldTimeDefault() {
        return 10;
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player playerEntity = (Player)user;
            int i = this.getMaxUseTime(stack) - remainingUseTicks;
            if (i >= 10) {
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                if (!world.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(user.m_7655_()));
                    ItemProjectileEntity projectileEntity = new ItemProjectileEntity(world, (LivingEntity)playerEntity, stack);
                    float divergence = (float)AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_ACCURACY);
                    float speed = (float)AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_SPEED);
                    float damage = (float)AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_DAMAGE);
                    damage /= speed;
                    if (stack.m_41720_() instanceof ModularItem) {
                        speed = 0.5f;
                    }
                    projectileEntity.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, speed, divergence);
                    projectileEntity.m_36781_(damage);
                    projectileEntity.setBowItem(ItemStack.f_41583_);
                    projectileEntity.m_36767_((byte)AttributeProperty.getActualValue(stack, EquipmentSlot.MAINHAND, AttributeRegistry.PROJECTILE_PIERCING));
                    projectileEntity.setSpeedDamage(true);
                    projectileEntity.setPreferredSlot(playerEntity.m_150109_().f_35977_);
                    projectileEntity.thrownStack = stack;
                    world.m_7967_((Entity)projectileEntity);
                    world.m_6269_(null, (Entity)user, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (playerEntity.m_150110_().f_35937_) {
                        projectileEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else {
                        user.m_21008_(user.m_7655_(), ItemStack.f_41583_);
                    }
                }
            }
        }
    }
}

