/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;

public abstract class EntityAttributeAbility
implements ItemUseDefaultCooldownAbility,
ItemUseMinHoldAbility {
    Map<LivingEntity, Multimap<Attribute, AttributeModifier>> playerEntityMultimapMap = new HashMap<LivingEntity, Multimap<Attribute, AttributeModifier>>();

    protected abstract Multimap<Attribute, AttributeModifier> getAttributes(ItemStack var1);

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        user.m_6672_(hand);
        Multimap<Attribute, AttributeModifier> attributeAttributePropertyMultimap = this.getAttributes(itemStack);
        attributeAttributePropertyMultimap.forEach((attribute, attributeModifier) -> {});
        user.m_21204_().m_22178_(attributeAttributePropertyMultimap);
        this.playerEntityMultimapMap.put((LivingEntity)user, attributeAttributePropertyMultimap);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    private void remove(ItemStack itemStack, LivingEntity livingEntity) {
        Multimap<Attribute, AttributeModifier> map;
        if (livingEntity instanceof Player) {
            Player playerEntity = (Player)livingEntity;
            playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        }
        if ((map = this.playerEntityMultimapMap.get(livingEntity)) != null) {
            livingEntity.m_21204_().m_22161_(map);
        }
    }

    @Override
    public ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user) {
        this.remove(stack, user);
        return stack;
    }

    @Override
    public void onStoppedUsingAfter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.remove(stack, user);
    }

    @Override
    public void onStoppedHolding(ItemStack stack, Level world, LivingEntity user) {
        this.remove(stack, user);
    }

    @Override
    public UseAnim getUseAction(ItemStack itemStack) {
        return UseAnim.NONE;
    }
}

