/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.util;

import dev.architectury.event.events.common.TickEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.AbilityMangerProperty;
import smartin.miapi.registries.MiapiRegistry;

public class ItemAbilityManager {
    private static final Map<Player, ItemStack> playerActiveItems = new HashMap<Player, ItemStack>();
    private static final Map<Player, ItemStack> playerActiveItemsClient = new HashMap<Player, ItemStack>();
    public static final MiapiRegistry<ItemUseAbility> useAbilityRegistry = MiapiRegistry.getInstance(ItemUseAbility.class);
    private static final EmptyAbility emptyAbility = new EmptyAbility();
    private static final Map<ItemStack, ItemUseAbility> abilityMap = new WeakHashMap<ItemStack, ItemUseAbility>();

    public static void setup() {
        TickEvent.PLAYER_PRE.register(playerEntity -> {
            Map<Player, ItemStack> activeItems = playerActiveItems;
            if (playerEntity.m_9236_().f_46443_) {
                activeItems = playerActiveItemsClient;
            }
            ItemStack oldItem = activeItems.get(playerEntity);
            ItemStack playerItem = playerEntity.m_21211_();
            if (playerItem != null && !playerItem.equals(oldItem)) {
                activeItems.put((Player)playerEntity, playerItem);
                if (oldItem != null) {
                    ItemUseAbility ability = ItemAbilityManager.getAbility(oldItem);
                    ability.onStoppedHolding(oldItem, playerEntity.m_9236_(), (LivingEntity)playerEntity);
                    abilityMap.remove(oldItem);
                }
            }
        });
        useAbilityRegistry.addCallback(ability -> ModularItemCache.setSupplier(AbilityMangerProperty.KEY + "_" + useAbilityRegistry.findKey((ItemUseAbility)ability), itemStack -> ability.fromJson(AbilityMangerProperty.getContext((ItemStack)itemStack, (ItemUseAbility)ability).contextJson)));
        useAbilityRegistry.register("empty", emptyAbility);
    }

    public static ItemUseAbility getEmpty() {
        return emptyAbility;
    }

    private static ItemUseAbility getAbility(ItemStack itemStack) {
        ItemUseAbility useAbility = abilityMap.get(itemStack);
        return useAbility == null ? emptyAbility : useAbility;
    }

    private static ItemUseAbility getAbility(ItemStack itemStack, Level world, Player player, InteractionHand hand, AbilityHitContext abilityHitContext) {
        for (ItemUseAbility ability : AbilityMangerProperty.get(itemStack)) {
            if (!ability.allowedOnItem(itemStack, world, player, hand, abilityHitContext)) continue;
            return ability;
        }
        return emptyAbility;
    }

    public static UseAnim getUseAction(ItemStack itemStack) {
        return ItemAbilityManager.getAbility(itemStack).getUseAction(itemStack);
    }

    public static int getMaxUseTime(ItemStack itemStack) {
        return ItemAbilityManager.getAbility(itemStack).getMaxUseTime(itemStack);
    }

    public static InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        ItemUseAbility ability = ItemAbilityManager.getAbility(itemStack, world, user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public UseOnContext hitResult() {
                return null;
            }

            @Override
            @Nullable
            public Entity hitEntity() {
                return null;
            }
        });
        abilityMap.put(itemStack, ability);
        return ability.use(world, user, hand);
    }

    public static ItemStack finishUsing(ItemStack stack, Level world, LivingEntity user) {
        ItemUseAbility ability = ItemAbilityManager.getAbility(stack);
        ItemStack itemStack = ability.finishUsing(stack, world, user);
        abilityMap.remove(stack);
        return itemStack;
    }

    public static void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        ItemUseAbility ability = ItemAbilityManager.getAbility(stack);
        ability.onStoppedUsing(stack, world, user, remainingUseTicks);
        if (ability instanceof ItemUseDefaultCooldownAbility) {
            ItemUseDefaultCooldownAbility itemUseDefaultCooldownAbility = (ItemUseDefaultCooldownAbility)ability;
            itemUseDefaultCooldownAbility.afterStopAbility(stack, world, user, remainingUseTicks);
        }
        abilityMap.remove(stack);
    }

    public static void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        ItemUseAbility ability = ItemAbilityManager.getAbility(stack);
        ability.usageTick(world, user, stack, remainingUseTicks);
    }

    public static InteractionResult useOnEntity(ItemStack stack, Player user, final LivingEntity entity, InteractionHand hand) {
        ItemUseAbility ability = ItemAbilityManager.getAbility(stack, user.m_9236_(), user, hand, new AbilityHitContext(){

            @Override
            @Nullable
            public UseOnContext hitResult() {
                return null;
            }

            @Override
            @Nullable
            public Entity hitEntity() {
                return entity;
            }
        });
        abilityMap.put(stack, ability);
        return ItemAbilityManager.getAbility(stack).useOnEntity(stack, user, entity, hand);
    }

    public static InteractionResult useOnBlock(final UseOnContext context) {
        ItemUseAbility ability = ItemAbilityManager.getAbility(context.m_43722_(), context.m_43725_(), context.m_43723_(), context.m_43724_(), new AbilityHitContext(){

            @Override
            @Nullable
            public UseOnContext hitResult() {
                return context;
            }

            @Override
            @Nullable
            public Entity hitEntity() {
                return null;
            }
        });
        abilityMap.put(context.m_43722_(), ability);
        return ItemAbilityManager.getAbility(context.m_43722_()).useOnBlock(context);
    }

    static class EmptyAbility
    implements ItemUseAbility {
        EmptyAbility() {
        }

        @Override
        public boolean allowedOnItem(ItemStack itemStack, Level world, Player player, InteractionHand hand, AbilityHitContext abilityHitContext) {
            return true;
        }

        @Override
        public UseAnim getUseAction(ItemStack itemStack) {
            return UseAnim.NONE;
        }

        @Override
        public int getMaxUseTime(ItemStack itemStack) {
            return 0;
        }

        @Override
        public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
            return InteractionResultHolder.m_19098_((Object)user.m_21120_(hand));
        }
    }

    public static interface AbilityHitContext {
        @Nullable
        public UseOnContext hitResult();

        @Nullable
        public Entity hitEntity();
    }
}

