/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.cache;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.network.Networking;

public class CacheCommands {
    public static String SEND_MATERIAL_CLIENT = "miapi_drop_cache";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literal = (LiteralArgumentBuilder)Commands.m_82127_((String)"miapi").then(Commands.m_82127_((String)"clear_cache").executes(CacheCommands::executeCacheClear));
        LiteralArgumentBuilder reloadCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"miapi").then(Commands.m_82127_((String)"miapi_reload").executes(CacheCommands::executeMiapiReload));
        dispatcher.register(literal);
        dispatcher.register(reloadCommand);
    }

    private static int executeCacheClear(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Clearing all miapi Caches"), false);
        if (((CommandSourceStack)context.getSource()).m_230897_()) {
            FriendlyByteBuf buf = Networking.createBuffer();
            buf.writeBoolean(true);
            Networking.sendS2C(SEND_MATERIAL_CLIENT, ((CommandSourceStack)context.getSource()).m_230896_(), buf);
        }
        ModularItemCache.discardCache();
        return 1;
    }

    private static int executeMiapiReload(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"starting reload"), false);
        return 1;
    }

    public static void triggerServerReload() {
        ++ReloadEvents.reloadCounter;
        LinkedHashMap<String, String> cacheDatapack = new LinkedHashMap<String, String>(ReloadEvents.DATA_PACKS);
        ReloadEvents.START.fireEvent(false);
        ReloadEvents.DataPackLoader.trigger(cacheDatapack);
        ReloadEvents.MAIN.fireEvent(false);
        ReloadEvents.END.fireEvent(false);
        --ReloadEvents.reloadCounter;
        Miapi.server.m_6846_().m_11314_().forEach(ReloadEvents::triggerReloadOnClient);
    }

    static ArgumentType<String> getArgumentType() {
        return new ArgumentType<String>(){

            public String parse(StringReader reader) {
                return reader.getRead();
            }

            public Collection<String> getExamples() {
                return CacheCommands.getMaterialOptions();
            }
        };
    }

    private static List<String> getMaterialOptions() {
        return MaterialProperty.materials.keySet().stream().toList();
    }
}

