/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.model.ModelTransformer;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.VisualModularItem;

public class ModularItemCache {
    protected static Map<String, CacheObjectSupplier> supplierMap = new HashMap<String, CacheObjectSupplier>();
    public static final long CACHE_SIZE = 1000L;
    public static final long CACHE_LIFETIME = 2L;
    public static final TimeUnit CACHE_LIFETIME_UNIT = TimeUnit.MINUTES;
    protected static final LoadingCache<UUID, Cache> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(2L, CACHE_LIFETIME_UNIT).build((CacheLoader)new CacheLoader<UUID, Cache>(){

        @NotNull
        public Cache load(@NotNull UUID key) {
            return new Cache(key, ItemStack.f_41583_);
        }
    });
    protected static Map<ItemStack, UUID> lookUpTable = new WeakHashMap<ItemStack, UUID>();
    protected static final LoadingCache<CompoundTag, UUID> nbtCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(2L, CACHE_LIFETIME_UNIT).build((CacheLoader)new CacheLoader<CompoundTag, UUID>(){

        @NotNull
        public UUID load(@NotNull CompoundTag key) {
            return ModularItemCache.getMissingUUID();
        }
    });

    public static void setSupplier(String key, CacheObjectSupplier supplier) {
        supplierMap.put(key, supplier);
    }

    @Nullable
    public static <T> T getRaw(ItemStack stack, String key) {
        if (!ReloadEvents.isInReload() && !stack.m_41619_() && stack.m_41720_() instanceof VisualModularItem) {
            Cache itemCache = ModularItemCache.find(stack);
            return (T)itemCache.get(key);
        }
        return null;
    }

    public static <T> T get(ItemStack stack, String key, T fallback) {
        if (!ReloadEvents.isInReload() && !stack.m_41619_() && stack.m_41720_() instanceof ModularItem) {
            Cache itemCache = ModularItemCache.find(stack);
            Object object = itemCache.get(key);
            if (object == null) {
                return fallback;
            }
            return (T)object;
        }
        return fallback;
    }

    public static <T> T getVisualOnlyCache(ItemStack stack, String key, T fallback) {
        if (!ReloadEvents.isInReload() && !stack.m_41619_() && stack.m_41720_() instanceof VisualModularItem) {
            Cache itemCache = ModularItemCache.find(stack);
            Object object = itemCache.get(key);
            if (object == null) {
                return fallback;
            }
            return (T)object;
        }
        return fallback;
    }

    public static void discardCache() {
        ((MiapiEvents.ReloadEvent)MiapiEvents.CACHE_CLEAR_EVENT.invoker()).onReload(Environment.isClient());
        cache.cleanUp();
        cache.invalidateAll();
        if (Environment.isClient()) {
            ModelTransformer.clearCaches();
            MaterialSpriteManager.clear();
        }
    }

    @Nullable
    public static UUID getUUIDFor(ItemStack stack) {
        try {
            if (stack.m_41720_() instanceof VisualModularItem && stack.m_41782_()) {
                return lookUpTable.getOrDefault(stack, (UUID)nbtCache.get((Object)stack.m_41784_()));
            }
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setUUIDFor(ItemStack stack, UUID uuid) {
        if (stack.m_41720_() instanceof VisualModularItem) {
            if (stack.m_41782_()) {
                nbtCache.put((Object)stack.m_41784_().m_6426_(), (Object)uuid);
                lookUpTable.put(stack, uuid);
            }
        } else {
            Miapi.LOGGER.error("this shouldn't not be called");
        }
    }

    public static void clearUUIDFor(ItemStack stack) {
        if (stack.m_41720_() instanceof VisualModularItem && stack.m_41782_()) {
            UUID uuid = ModularItemCache.getUUIDFor(stack);
            nbtCache.invalidate((Object)stack.m_41784_());
            cache.invalidate((Object)uuid);
            lookUpTable.remove(stack);
        }
    }

    protected static Cache find(ItemStack stack) {
        UUID lookUpUUId = ModularItemCache.getUUIDFor(stack);
        if (lookUpUUId == null) {
            lookUpUUId = ModularItemCache.getMissingUUID();
        }
        UUID uuid = lookUpUUId;
        try {
            Cache cacheEntry = (Cache)cache.get((Object)uuid, () -> new Cache(uuid, stack));
            if (cacheEntry.isValidItem(stack)) {
                return cacheEntry;
            }
            cache.invalidate((Object)uuid);
            UUID newUUID = ModularItemCache.getMissingUUID();
            return (Cache)cache.get((Object)newUUID, () -> new Cache(newUUID, stack));
        }
        catch (ExecutionException ignored) {
            UUID uuid1 = ModularItemCache.getMissingUUID();
            Cache cache1 = new Cache(uuid1, stack);
            cache.put((Object)uuid1, (Object)cache1);
            return cache1;
        }
    }

    protected static UUID getMissingUUID() {
        UUID uuid;
        while (cache.getIfPresent((Object)(uuid = UUID.randomUUID())) != null) {
        }
        return uuid;
    }

    protected static class Cache {
        protected Map<String, Object> map = new ConcurrentHashMap<String, Object>();
        public UUID uuid;
        public ItemStack stack;
        public CompoundTag compound;

        public Cache(UUID uuid, ItemStack stack) {
            this.uuid = uuid;
            this.stack = stack;
            this.compound = stack.m_41784_().m_6426_();
            ModularItemCache.setUUIDFor(stack, uuid);
        }

        public boolean isValidItem(ItemStack itemStack) {
            return ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)this.stack) && itemStack.m_41784_().equals((Object)this.compound);
        }

        public void set(String key, Object object) {
            this.map.put(key, object);
        }

        public Object get(String key) {
            if (this.map.containsKey(key)) {
                return this.map.get(key);
            }
            CacheObjectSupplier supplier = supplierMap.get(key);
            if (supplier != null) {
                Object cached = supplier.apply(this.stack);
                if (cached != null) {
                    this.map.put(key, cached);
                }
                return cached;
            }
            return null;
        }
    }

    public static interface CacheObjectSupplier
    extends Function<ItemStack, Object> {
        @Override
        public Object apply(ItemStack var1);
    }
}

