/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.mixin.ClientAdvancementManagerAccessor;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.conditions.NotCondition;
import smartin.miapi.modules.conditions.TrueCondition;

public class AdvancementCondition
implements ModuleCondition {
    ResourceLocation advancement = null;

    public AdvancementCondition() {
    }

    public AdvancementCondition(ResourceLocation perms) {
        this.advancement = perms;
    }

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        if (conditionContext instanceof ConditionManager.ModuleConditionContext) {
            Advancement advancement1;
            ConditionManager.ModuleConditionContext moduleConditionContext = (ConditionManager.ModuleConditionContext)conditionContext;
            Player player = moduleConditionContext.player;
            List<Component> reasons = moduleConditionContext.reasons;
            if (player != null && this.advancement != null && (advancement1 = this.getAdvancement(this.advancement)) != null) {
                return AdvancementCondition.hasAdvancement(advancement1, player);
            }
            reasons.add((Component)Component.m_237113_((String)"Unavailable."));
        }
        return false;
    }

    public static boolean hasAdvancement(Advancement advancement, Player player) {
        if (Environment.isClient()) {
            return AdvancementCondition.hasAdvancementClient(advancement, player);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            return serverPlayerEntity.m_8960_().m_135996_(advancement).m_8193_();
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasAdvancementClient(Advancement advancement, Player player) {
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().m_91403_() != null) {
            ClientAdvancements manager = Minecraft.m_91087_().m_91403_().m_105145_();
            return ((ClientAdvancementManagerAccessor)manager).getAdvancementProgresses().get(advancement).m_8193_();
        }
        return false;
    }

    @Override
    public ModuleCondition load(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            ResourceLocation identifier = new ResourceLocation(object.get("advancement").getAsString());
            return new AdvancementCondition(identifier);
        }
        return new NotCondition(new TrueCondition());
    }

    public Advancement getAdvancement(ResourceLocation identifier) {
        if (Environment.isClient()) {
            return this.getAdvancementClient(identifier);
        }
        if (Miapi.server != null) {
            return Miapi.server.m_129889_().m_136041_(identifier);
        }
        return null;
    }

    public Advancement getAdvancementClient(ResourceLocation identifier) {
        if (Minecraft.m_91087_().m_91403_() != null) {
            return Minecraft.m_91087_().m_91403_().m_105145_().m_104396_().m_139337_(identifier);
        }
        return null;
    }
}

