/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import smartin.miapi.Miapi;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.conditions.TrueCondition;

public class ItemInInventoryCondition
implements ModuleCondition {
    public Ingredient item;
    public MinMaxBounds.Ints count = MinMaxBounds.Ints.m_55386_((int)1);

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        if (conditionContext instanceof ConditionManager.ModuleConditionContext) {
            ConditionManager.ModuleConditionContext moduleConditionContext = (ConditionManager.ModuleConditionContext)conditionContext;
            Player player = moduleConditionContext.player;
            List<Component> reasons = moduleConditionContext.reasons;
            if (player != null && this.count.m_55390_(this.getCount((Container)player.m_150109_(), this.item))) {
                return true;
            }
            int min = this.count.m_55305_() == null ? 0 : (Integer)this.count.m_55305_();
            Integer max = (Integer)this.count.m_55326_();
            String ingredientName = "";
            if (this.item.m_43908_() != null && this.item.m_43908_().length > 1) {
                ingredientName = Component.m_237115_((String)this.item.m_43908_()[0].m_41720_().m_5524_()).toString();
            }
            MutableComponent text = max != null ? Component.m_237110_((String)"miapi.condition.item_in_inventory.error.specific", (Object[])new Object[]{min, max, ingredientName}) : Component.m_237110_((String)"miapi.condition.item_in_inventory.error.no_max", (Object[])new Object[]{min, ingredientName});
            reasons.add((Component)text);
        }
        return false;
    }

    public int getCount(Container inventory, Ingredient ingredient) {
        int found = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!ingredient.test(inventory.m_8020_(i))) continue;
            found += inventory.m_8020_(i).m_41613_();
        }
        return found;
    }

    @Override
    public ModuleCondition load(JsonElement element) {
        try {
            JsonObject object = element.getAsJsonObject();
            if (!object.has("item")) {
                throw new RuntimeException("Expected key 'item' for ItemInInventoryCondition, but it was not found.");
            }
            Ingredient item = Ingredient.m_43917_((JsonElement)object.get("item"));
            ItemInInventoryCondition condition = new ItemInInventoryCondition();
            condition.item = item;
            JsonElement countElement = object.get("count");
            if (countElement != null) {
                condition.count = MinMaxBounds.Ints.m_55373_((JsonElement)countElement);
            }
            return condition;
        }
        catch (Exception e) {
            Miapi.LOGGER.error("Could not load ItemInInventoryCondition ", (Throwable)e);
            return new TrueCondition();
        }
    }
}

