/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.conditions;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.properties.TagProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class TagCondition
implements ModuleCondition {
    public String tag = "";
    Component onFalse = null;

    public TagCondition() {
    }

    public TagCondition(String tag) {
        this.tag = tag;
    }

    @Override
    public boolean isAllowed(ConditionManager.ConditionContext conditionContext) {
        if (conditionContext instanceof ConditionManager.ModuleConditionContext) {
            ConditionManager.ModuleConditionContext moduleConditionContext = (ConditionManager.ModuleConditionContext)conditionContext;
            Map<ModuleProperty, JsonElement> propertyMap = moduleConditionContext.propertyMap;
            List<Component> reasons = moduleConditionContext.reasons;
            reasons.add(this.onFalse);
            if (TagProperty.getTags(propertyMap).contains(this.tag)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ModuleCondition load(JsonElement element) {
        TagCondition condition = new TagCondition(element.getAsJsonObject().get("tag").getAsString());
        condition.onFalse = ModuleProperty.getText(element.getAsJsonObject(), "error", (Component)Component.m_237115_((String)"miapi.condition.tag.error"));
        return new TagCondition(element.getAsJsonObject().get("tag").getAsString());
    }
}

