/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.EditModuleCrafter;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.edit_options.EditOptionIcon;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.network.Networking;

public class CosmeticEditOption
implements EditOption {
    public static ItemStack hoverStack = ItemStack.f_41583_;
    public static int updateCount = 0;
    @Nullable
    public static EditOption.EditContext unsafeEditContext;
    @Nullable
    public static CraftAction unsafeCraftAction;
    public String slotType = "cosmetic";

    @Override
    public ItemStack preview(FriendlyByteBuf buffer, EditOption.EditContext editContext) {
        CraftAction action = new CraftAction(buffer, editContext.getWorkbench());
        if (editContext.getLinkedInventory() == null) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = editContext.getLinkedInventory().m_8020_(0);
        action.setItem(itemStack);
        Container inventory = editContext.getLinkedInventory();
        if (hoverStack != null && !hoverStack.m_41619_()) {
            boolean emptyMaterial = editContext.getLinkedInventory().m_8020_(1).m_41619_();
            inventory = new SimpleContainer(2);
            inventory.m_6836_(1, hoverStack);
        }
        action.linkInventory(inventory, 1);
        return action.getPreview();
    }

    public static void tryPreview() {
        if (unsafeEditContext != null && unsafeCraftAction != null) {
            try {
                unsafeEditContext.preview(unsafeCraftAction.toPacket(Networking.createBuffer()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setHoverStack(ItemStack itemStack, boolean safe) {
        Material material;
        updateCount = 2;
        if (itemStack != null && hoverStack != null && ItemStack.m_41728_((ItemStack)itemStack, (ItemStack)hoverStack)) {
            return;
        }
        if (!itemStack.m_41619_() && (material = MaterialProperty.getMaterialFromIngredient(itemStack)) != null) {
            hoverStack = itemStack;
            CosmeticEditOption.tryPreview();
            return;
        }
        if (!safe) {
            hoverStack = itemStack;
            CosmeticEditOption.tryPreview();
        }
    }

    @Override
    public ItemStack execute(FriendlyByteBuf buffer, EditOption.EditContext editContext) {
        CraftAction action = new CraftAction(buffer, editContext.getWorkbench());
        action.setItem(editContext.getLinkedInventory().m_8020_(0));
        action.linkInventory(editContext.getLinkedInventory(), 1);
        if (action.canPerform()) {
            return action.perform();
        }
        Miapi.LOGGER.warn("Could not previewStack Craft Action. This might indicate an exploit by " + editContext.getPlayer().m_20149_());
        return editContext.getItemstack();
    }

    @Override
    public boolean isVisible(EditOption.EditContext editContext) {
        SlotProperty.ModuleSlot slot = editContext.getSlot();
        if (editContext.getInstance() != null) {
            slot = SlotProperty.getSlotIn(editContext.getInstance());
        }
        if (slot != null && editContext.getSlot().slotType.equals(this.slotType)) {
            return true;
        }
        if (editContext.getInstance() != null) {
            return SlotProperty.getSlots(editContext.getInstance()).values().stream().anyMatch(moduleSlot -> moduleSlot.slotType.equals(this.slotType));
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getGui(int x, int y, int width, int height, EditOption.EditContext editContext) {
        hoverStack = null;
        unsafeEditContext = editContext;
        return new EditModuleCrafter(x, y, width, height, this, editContext, this.slotType);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget getIconGui(int x, int y, int width, int height, Consumer<EditOption> select, Supplier<EditOption> getSelected) {
        hoverStack = null;
        unsafeEditContext = null;
        return new EditOptionIcon(x, y, width, height, select, getSelected, CraftingScreen.BACKGROUND_TEXTURE, 339, 175, 512, 512, "miapi.ui.edit_option.hover.cosmetic", this);
    }
}

