/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.skins.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.edit_options.skins.Skin;
import smartin.miapi.modules.edit_options.skins.gui.SkinGui;

class SkinButton
extends InteractAbleWidget
implements SkinGui.SortAble {
    private final SkinGui skinGui;
    String skinPath;
    Skin skin;
    String sortAble;
    ScrollingTextWidget textWidget;
    static final int SIZE_Y = 16;
    public boolean isEnabled = true;
    public boolean isAllowed = true;
    public List<Component> reasons = new ArrayList<Component>();
    public int timeHover = 0;

    public SkinButton(SkinGui skinGui, int x, int y, int width, String skinPath, Skin skin) {
        super(x, y, width, 16, (Component)Component.m_237119_());
        this.skinGui = skinGui;
        this.skinPath = skinPath;
        this.skin = skin;
        if (skin.condition != null) {
            this.isAllowed = skin.condition.isAllowed(new ConditionManager.ModuleConditionContext(skinGui.instance, null, (Player)Minecraft.m_91087_().f_91074_, skinGui.instance.getProperties(), this.reasons));
        }
        String[] parts = skinPath.split("/");
        Component skinName = StatResolver.translateAndResolve("miapi.skin.name." + parts[parts.length - 1], skinGui.instance);
        this.sortAble = skinName.getString();
        this.textWidget = new ScrollingTextWidget(x + 3, y + 2, width - 6, skinName, skin.textureOptions.color());
    }

    @Override
    public void m_88315_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        int hover;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.skin.textureOptions.texture());
        int n = hover = this.m_5953_(mouseX, mouseY) ? this.skin.textureOptions.ySize() : 0;
        if (!this.isAllowed) {
            hover *= 3;
        } else {
            int n2 = hover = this.skinGui.currentSkin().equals(this.skinPath) ? this.skin.textureOptions.ySize() * 2 : hover;
        }
        if (this.m_5953_(mouseX, mouseY)) {
            hover = this.skin.textureOptions.ySize();
        }
        SkinButton.drawTextureWithEdge(drawContext, this.skin.textureOptions.texture(), this.m_252754_(), this.m_252907_(), 0, hover, 100, 16, this.f_93618_, this.f_93619_, this.skin.textureOptions.xSize(), this.skin.textureOptions.ySize() * 3, this.skin.textureOptions.borderSize());
        this.textWidget.m_253211_(this.m_252907_() + 4);
        this.textWidget.m_88315_(drawContext, mouseX, mouseY, delta);
        this.children().forEach(element -> {
            if (element instanceof Renderable) {
                Renderable drawable = (Renderable)element;
                drawable.m_88315_(drawContext, mouseX, mouseY, delta);
            }
        });
        if (this.m_5953_(mouseX, mouseY)) {
            this.skinGui.setPreview(this.skinPath);
        }
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (!this.isAllowed) {
            if (this.m_5953_(mouseX, mouseY)) {
                drawContext.m_280666_(Minecraft.m_91087_().f_91062_, this.reasons, mouseX, mouseY);
            }
        } else if (this.m_5953_(mouseX, mouseY) && this.skin.hoverDescription != null) {
            drawContext.m_280557_(Minecraft.m_91087_().f_91062_, this.skin.hoverDescription, mouseX, mouseY);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY) && this.isAllowed) {
            this.skinGui.setCraft(this.skinPath);
            return true;
        }
        return false;
    }

    @Override
    public void filter(String search) {
        this.isEnabled = this.skinPath.toLowerCase().contains(search.toLowerCase()) || this.textWidget.getText().toString().toLowerCase().contains(search.toLowerCase());
    }

    @Override
    public String sortAndGetTop() {
        return this.sortAble;
    }

    @Override
    public boolean isActive() {
        return this.isEnabled && this.isAllowed;
    }
}

