/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.skins.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.ClickAbleTextWidget;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.edit_options.skins.Skin;
import smartin.miapi.modules.edit_options.skins.SkinOptions;
import smartin.miapi.modules.edit_options.skins.gui.SkinTabGui;
import smartin.miapi.network.Networking;

public class SkinGui
extends InteractAbleWidget {
    public final Consumer<FriendlyByteBuf> craft;
    public final Consumer<FriendlyByteBuf> preview;
    public String currentPreview;
    public ItemModule.ModuleInstance instance;

    @OnlyIn(value=Dist.CLIENT)
    public SkinGui(int x, int y, int width, int height, ItemStack stack, ItemModule.ModuleInstance instance, Consumer<FriendlyByteBuf> craft, Consumer<FriendlyByteBuf> preview) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.craft = craft;
        this.preview = preview;
        this.instance = instance;
        Map<String, Skin> maps = SkinOptions.skins.get(instance.module);
        if (maps == null) {
            maps = new HashMap<String, Skin>();
        }
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        SkinTabGui parentSkinTab = new SkinTabGui(this, x, y + 30, width, "", maps);
        widgets.add(parentSkinTab);
        ScrollList list = new ScrollList(x, y + 30, width, height - 30, widgets);
        this.addChild(list);
        ClickAbleTextWidget textFieldWidget = new ClickAbleTextWidget(Minecraft.m_91087_().f_91062_, x + 2, y + 2, this.f_93618_ - 4, 18, (Component)Component.m_237113_((String)"TITLE"));
        textFieldWidget.m_94199_(Integer.MAX_VALUE);
        textFieldWidget.m_94186_(true);
        textFieldWidget.m_94194_(true);
        textFieldWidget.m_257771_((Component)Component.m_237115_((String)"miapi.ui.search_placeholder"));
        textFieldWidget.m_94151_(parentSkinTab::filter);
        this.addChild((GuiEventListener)textFieldWidget);
    }

    public String currentSkin() {
        if (this.instance != null) {
            return this.instance.moduleData.getOrDefault("skin", "");
        }
        Miapi.LOGGER.warn("instance null??????");
        return "";
    }

    public void setPreview(String skinPath) {
        if (!skinPath.equals(this.currentPreview)) {
            this.currentPreview = skinPath;
            FriendlyByteBuf buf = Networking.createBuffer();
            buf.m_130070_(skinPath);
            this.preview.accept(buf);
        }
    }

    public void setCraft(String skinPath) {
        this.currentPreview = skinPath;
        FriendlyByteBuf buf = Networking.createBuffer();
        buf.m_130070_(skinPath);
        this.craft.accept(buf);
    }

    static interface SortAble {
        public void filter(String var1);

        public String sortAndGetTop();

        public boolean isActive();
    }
}

