/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.crafter.replace.MaterialCraftingWidget;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.DurabilityProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class AllowedMaterial
implements CraftingProperty,
ModuleProperty {
    public static final String KEY = "allowedMaterial";
    public static AllowedMaterial property;
    public double materialCostClient = 0.0;
    public double materialRequirementClient = 0.0;
    public boolean wrongMaterial = false;
    public boolean smithingMaterial = false;
    public int slotHeight = 116;

    public AllowedMaterial() {
        property = this;
    }

    public List<String> getAllowedKeys(ItemModule module) {
        JsonElement element = module.getProperties().get(KEY);
        if (element != null) {
            AllowedMaterialJson json = (AllowedMaterialJson)Miapi.gson.fromJson(element, AllowedMaterialJson.class);
            return json.allowedMaterials;
        }
        return new ArrayList<String>();
    }

    public List<Material> getMaterials(String key) {
        return MaterialProperty.materials.values().stream().filter(a -> a.getGroups().contains(key)).collect(Collectors.toList());
    }

    @Override
    public List<Vec2> getSlotPositions() {
        ArrayList<Vec2> test = new ArrayList<Vec2>();
        test.add(new Vec2(96.0f, (float)(this.slotHeight - 12)));
        return test;
    }

    @Override
    public float getPriority() {
        return -1.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget createGui(int x, int y, int width, int height, CraftAction action) {
        return new MaterialCraftingWidget(this, x, y, width, height, action);
    }

    @Override
    public Component getWarning() {
        if (this.wrongMaterial) {
            if (this.smithingMaterial) {
                Component.m_237115_((String)"miapi.ui.craft.warning.material.wrong.smithing");
            }
            return Component.m_237115_((String)"miapi.ui.craft.warning.material.wrong");
        }
        return Component.m_237115_((String)"miapi.ui.craft.warning.material");
    }

    @Override
    public boolean canPerform(ItemStack old, ItemStack crafting, ModularWorkBenchEntity bench, Player player, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        JsonElement element = module.getProperties().get(KEY);
        ItemStack input = inventory.get(0);
        if (element != null) {
            AllowedMaterialJson json = (AllowedMaterialJson)Miapi.gson.fromJson(element, AllowedMaterialJson.class);
            Material material = MaterialProperty.getMaterialFromIngredient(input);
            this.materialRequirementClient = json.cost * (float)crafting.m_41613_();
            if (material != null) {
                boolean isAllowed = json.allowedMaterials.stream().anyMatch(allowedMaterial -> material.getGroups().contains(allowedMaterial));
                boolean bl = this.wrongMaterial = !isAllowed;
                if (isAllowed) {
                    this.materialCostClient = (double)input.m_41613_() * material.getValueOfItem(input);
                    return this.materialCostClient >= this.materialRequirementClient;
                }
                this.materialCostClient = 0.0;
                this.smithingMaterial = material.getGroups().contains("smithing");
            } else {
                this.smithingMaterial = false;
                this.wrongMaterial = false;
                this.materialCostClient = 0.0;
            }
        } else {
            this.wrongMaterial = false;
        }
        return false;
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        Material material;
        ItemModule.ModuleInstance newModule = craftAction.getModifyingModuleInstance(crafting);
        JsonElement element = module.getProperties().get(KEY);
        ItemStack input = inventory.get(0);
        ItemStack materialStack = input.m_41777_();
        if (element != null && (material = MaterialProperty.getMaterialFromIngredient(input)) != null) {
            AllowedMaterialJson json = (AllowedMaterialJson)Miapi.gson.fromJson(element, AllowedMaterialJson.class);
            boolean isAllowed = json.allowedMaterials.stream().anyMatch(allowedMaterial -> material.getGroups().contains(allowedMaterial));
            if (isAllowed) {
                MaterialProperty.setMaterial(newModule, material.getKey());
            }
            newModule.getRoot().writeToItem(crafting);
            MiapiEvents.MaterialCraftEventData eventData = new MiapiEvents.MaterialCraftEventData(crafting, materialStack, material, newModule, craftAction);
            ((MiapiEvents.MaterialCraftEvent)MiapiEvents.MATERIAL_CRAFT_EVENT.invoker()).craft(eventData);
            crafting = eventData.crafted;
        }
        if (crafting.m_41763_() && crafting.m_41773_() > 0) {
            ModularItemCache.clearUUIDFor(crafting);
            ItemModule.ModuleInstance moduleInstance = craftAction.getModifyingModuleInstance(crafting);
            Double scannedDurability = DurabilityProperty.property.getValueForModule(moduleInstance, 0.0);
            int durability = (int)((double)scannedDurability.intValue() * MiapiConfig.INSTANCE.server.other.repairRatio);
            crafting.m_41721_(crafting.m_41773_() - durability);
        }
        return crafting;
    }

    @Override
    public List<ItemStack> performCraftAction(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        ItemModule.ModuleInstance newModule = craftAction.getModifyingModuleInstance(crafting);
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        JsonElement element = module.getProperties().get(KEY);
        ItemStack input = inventory.get(0);
        ItemStack materialStack = input.m_41777_();
        AllowedMaterialJson json = (AllowedMaterialJson)Miapi.gson.fromJson(element, AllowedMaterialJson.class);
        Material material = MaterialProperty.getMaterialFromIngredient(input);
        assert (material != null);
        int newCount = (int)((double)input.m_41613_() - Math.ceil((double)(json.cost * (float)crafting.m_41613_()) / material.getValueOfItem(input)));
        if (!player.m_9236_().m_5776_()) {
            input.m_41764_(newCount);
        }
        assert (newModule != null);
        MaterialProperty.setMaterial(newModule, material.getKey());
        newModule.getRoot().writeToItem(crafting);
        MiapiEvents.MaterialCraftEventData eventData = new MiapiEvents.MaterialCraftEventData(crafting, materialStack, material, newModule, craftAction);
        ((MiapiEvents.MaterialCraftEvent)MiapiEvents.MATERIAL_CRAFT_EVENT.invoker()).craft(eventData);
        crafting = eventData.crafted;
        if (crafting.m_41763_()) {
            int durability = (int)((double)DurabilityProperty.property.getValueForModule(craftAction.getModifyingModuleInstance(crafting), 0.0).intValue() * MiapiConfig.INSTANCE.server.other.repairRatio);
            crafting.m_41721_(crafting.m_41773_() - durability);
        }
        results.add(crafting);
        results.add(input);
        return results;
    }

    public static double getMaterialCost(ItemModule.ModuleInstance moduleInstance) {
        JsonElement element = property.getJsonElement(moduleInstance);
        if (element != null) {
            return ((AllowedMaterialJson)Miapi.gson.fromJson((JsonElement)element, AllowedMaterialJson.class)).cost;
        }
        return 0.0;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    static class AllowedMaterialJson {
        public List<String> allowedMaterials;
        public float cost;

        AllowedMaterialJson() {
        }
    }
}

