/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.palette.MaterialRenderController;
import smartin.miapi.modules.properties.util.ModuleProperty;

public interface Material {
    public static final ResourceLocation BASE_PALETTE_ID = new ResourceLocation("miapi", "miapi_materials/base_palette");

    public String getKey();

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(String color) {
        if (color.equals("")) {
            return FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
        }
        long longValue = Long.parseLong(color, 16);
        return (int)(longValue & 0xFFFFFFFFL);
    }

    public List<String> getGroups();

    default public List<String> getGuiGroups() {
        return this.getGroups();
    }

    @OnlyIn(value=Dist.CLIENT)
    public MaterialRenderController getRenderController();

    @OnlyIn(value=Dist.CLIENT)
    default public int renderIcon(GuiGraphics drawContext, int x, int y) {
        return 0;
    }

    default public Material getMaterial(ItemModule.ModuleInstance moduleInstance) {
        return this;
    }

    default public Material getMaterialFromIngredient(ItemStack ingredient) {
        return this;
    }

    default public Component getTranslation() {
        return Component.m_237115_((String)this.getData("translation"));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public boolean hasIcon() {
        return false;
    }

    public Map<ModuleProperty, JsonElement> materialProperties(String var1);

    default public Map<ModuleProperty, JsonElement> getDisplayMaterialProperties(String key) {
        return this.materialProperties(key);
    }

    public List<String> getAllPropertyKeys();

    default public List<String> getAllDisplayPropertyKeys() {
        return this.getAllPropertyKeys();
    }

    public double getDouble(String var1);

    public String getData(String var1);

    default public boolean generateConverters() {
        return false;
    }

    public List<String> getTextureKeys();

    @OnlyIn(value=Dist.CLIENT)
    default public int getColor() {
        return this.getRenderController().getAverageColor().argb();
    }

    public double getValueOfItem(ItemStack var1);

    @Nullable
    public Double getPriorityOfIngredientItem(ItemStack var1);

    public JsonObject getDebugJson();
}

