/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.codec.misc.MiscCodecs;
import com.redpxnda.nucleus.codec.misc.PolyCodec;
import com.redpxnda.nucleus.util.InterfaceDispatcher;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import smartin.miapi.Miapi;

public class MaterialIcons {
    public static final Map<String, MaterialIconCreator> iconCreators = new HashMap<String, MaterialIconCreator>();
    private static final InterfaceDispatcher<MaterialIconCreator> dispatcher = InterfaceDispatcher.of(iconCreators, (String)"type", (Object[])new MaterialIconCreator[0]);
    public static MaterialIconCreator textureIconCreator;

    public static MaterialIcon getMaterialIcon(String materialKey, JsonElement element) {
        return ((MaterialIconCreator)dispatcher.dispatcher()).create(element, materialKey);
    }

    public static void setup() {
        textureIconCreator = (element, mat) -> {
            JsonPrimitive primitive;
            if (!(element instanceof JsonObject)) {
                throw new RuntimeException("JSON data for the icon of the '" + mat + "' material is not a JSON object! -> " + element);
            }
            JsonObject object = (JsonObject)element;
            JsonElement patt2240$temp = object.get("path");
            if (!(patt2240$temp instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)patt2240$temp).isString()) {
                throw new RuntimeException("'path' field for the icon of the '" + mat + "' material is either missing, or not a string! -> " + element);
            }
            return new TextureMaterialIcon(new ResourceLocation(primitive.getAsString()));
        };
        iconCreators.put("texture", textureIconCreator);
        Codec byItem = BuiltInRegistries.f_257033_.m_194605_().xmap(Item::m_7968_, ItemStack::m_41720_);
        iconCreators.put("item", (element, mat) -> {
            int n;
            if (!(element instanceof JsonObject)) {
                throw new RuntimeException("JSON data for the icon of the '" + mat + "' material is not a JSON object! -> " + element);
            }
            JsonObject object = (JsonObject)element;
            if (!object.has("item")) {
                throw new RuntimeException("'item' field for the icon of the '" + mat + "' material is missing! -> " + element);
            }
            ItemStack stack = (ItemStack)MiscCodecs.quickParse((JsonElement)object.get("item"), (Codec)PolyCodec.of((Codec[])new Codec[]{byItem, ItemStack.f_41582_}), s -> Miapi.LOGGER.error("Failed to parse item for the icon of the '{}' material! -> {}", (Object)mat, s));
            JsonElement jsonElement = object.get("offset");
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive prim = (JsonPrimitive)jsonElement;
                n = prim.getAsInt();
            } else {
                n = 16;
            }
            int offset = n;
            SpinSettings spin = object.has("spin") ? (SpinSettings)MiscCodecs.quickParse((JsonElement)object.get("spin"), SpinSettings.codec, s -> Miapi.LOGGER.error("Failed to parse spin settings for item icon of the '{}' material! -> {}", (Object)mat, s)) : null;
            return new ItemMaterialIcon(stack, offset, spin);
        });
        iconCreators.put("entity", (element, materialKey) -> {
            EntityIconHolder holder = (EntityIconHolder)MiscCodecs.quickParse((JsonElement)element, EntityIconHolder.codec, s -> Miapi.LOGGER.error("Failed to parse entity icon for the '{}' material! -> {}", (Object)materialKey, s));
            return new EntityMaterialIcon(holder);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderRotatingItem(GuiGraphics context, ItemStack stack, int x, int y, int z, SpinSettings spin) {
        if (stack.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel bakedModel = itemRenderer.m_174264_(stack, (Level)Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_((float)(x + 8), (float)(y + 8), (float)(150 + (bakedModel.m_7539_() ? z : 0)));
        boolean bl = !bakedModel.m_7547_();
        context.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        context.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        spin.multiplyMatrices(context.m_280168_());
        if (bl) {
            Lighting.m_84930_();
        }
        itemRenderer.m_115143_(stack, ItemDisplayContext.GUI, false, context.m_280168_(), (MultiBufferSource)context.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        context.m_280262_();
        if (bl) {
            Lighting.m_84931_();
        }
        context.m_280168_().m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderRotatingEntity(GuiGraphics context, int x, int y, int z, EntityIconHolder holder) {
        if (holder.actual == null) {
            holder.actual = holder.entity.m_20615_((Level)Minecraft.m_91087_().f_91073_);
        }
        EntityRenderDispatcher renderer = Minecraft.m_91087_().m_91290_();
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_((float)(x + 8) + holder.x, (float)(y + 16) - holder.y, (float)(150 + z));
        context.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        context.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        context.m_280168_().m_85841_(holder.scale, holder.scale, holder.scale);
        if (holder.spin != null) {
            holder.spin.multiplyMatrices(context.m_280168_());
        }
        renderer.m_114384_(holder.actual, 0.0, 0.0, 0.0, 0.0f, 0.0f, context.m_280168_(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0xF000F0);
        context.m_280262_();
        context.m_280168_().m_85849_();
    }

    public static interface MaterialIconCreator {
        public MaterialIcon create(JsonElement var1, String var2);
    }

    public static interface MaterialIcon {
        @OnlyIn(value=Dist.CLIENT)
        public int render(GuiGraphics var1, int var2, int var3);
    }

    @CodecBehavior.Override(value="codec")
    @AutoCodec.Settings(defaultOptionalBehavior=@CodecBehavior.Optional)
    public static class SpinSettings {
        public static final Codec<SpinSettings> codec = AutoCodec.of(SpinSettings.class).codec();
        public boolean x = false;
        public boolean y = true;
        public boolean z = false;
        public int originX = 0;
        public int originY = 0;
        public int originZ = 0;
        public float speed = 1.0f;

        public void multiplyMatrices(PoseStack matrices) {
            float amount = (float)Util.m_137550_() * (1.745E-4f * this.speed);
            matrices.m_272245_(new Quaternionf().rotationXYZ(this.x ? amount : 0.0f, this.y ? amount : 0.0f, this.z ? amount : 0.0f), (float)this.originX, (float)this.originY, (float)this.originZ);
        }
    }

    public static class EntityIconHolder {
        public static final Codec<EntityIconHolder> codec = AutoCodec.of(EntityIconHolder.class).codec();
        @AutoCodec.Ignored
        public Entity actual = null;
        public EntityType<?> entity;
        @CodecBehavior.Optional
        public int offset = 16;
        @CodecBehavior.Optional
        public float x = 0.0f;
        @CodecBehavior.Optional
        public float y = 0.0f;
        @CodecBehavior.Optional
        public float scale = 0.85f;
        @CodecBehavior.Optional
        public SpinSettings spin = null;
    }

    public record EntityMaterialIcon(EntityIconHolder holder) implements MaterialIcon
    {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public int render(GuiGraphics context, int x, int y) {
            MaterialIcons.renderRotatingEntity(context, x, y, 0, this.holder);
            return this.holder.offset;
        }
    }

    public record ItemMaterialIcon(ItemStack item, int offset, SpinSettings spin) implements MaterialIcon
    {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public int render(GuiGraphics context, int x, int y) {
            if (this.spin != null) {
                MaterialIcons.renderRotatingItem(context, this.item, x, y, 0, this.spin);
            } else {
                context.m_280480_(this.item, x, y);
            }
            return this.offset;
        }
    }

    public record TextureMaterialIcon(ResourceLocation texture) implements MaterialIcon
    {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public int render(GuiGraphics context, int x, int y) {
            context.m_280163_(this.texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            return 16;
        }
    }
}

