/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.event.EventResult;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class MaterialInscribeDataProperty
implements ModuleProperty {
    public static final String KEY = "inscribe_data_on_craft";
    public static MaterialInscribeDataProperty property;

    public MaterialInscribeDataProperty() {
        property = this;
        MiapiEvents.MATERIAL_CRAFT_EVENT.register(listener -> {
            listener.crafted = MaterialInscribeDataProperty.inscribe(listener);
            return EventResult.pass();
        });
    }

    public static ItemStack inscribe(MiapiEvents.MaterialCraftEventData data) {
        ItemStack raw = data.crafted;
        JsonElement element = ItemModule.getMergedProperty(raw, (ModuleProperty)property);
        if (element != null) {
            MaterialInscribeDataProperty.inscribeModuleInstance(data.moduleInstance, data.materialStack.m_41777_(), element.getAsString());
            data.moduleInstance.getRoot().writeToItem(data.crafted);
        }
        return raw;
    }

    public static void inscribeModuleInstance(ItemModule.ModuleInstance moduleInstance, ItemStack itemStack, String key) {
        CompoundTag nbtElement = itemStack.m_41739_(new CompoundTag());
        moduleInstance.moduleData.put(key, nbtElement.m_7916_());
    }

    public static ItemStack readStackFromModuleInstance(ItemModule.ModuleInstance moduleInstance, String key) {
        String itemStackString = moduleInstance.moduleData.get(key);
        if (itemStackString != null) {
            try {
                return ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)itemStackString));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsString();
        return true;
    }
}

