/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import smartin.miapi.item.modular.PropertyResolver;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class MaterialProperties
implements ModuleProperty {
    public static String KEY = "materialProperty";
    public static MaterialProperties property;

    public MaterialProperties() {
        property = this;
        PropertyResolver.register("material_property", (moduleInstance, oldMap) -> {
            Material material = MaterialProperty.getMaterial((JsonElement)oldMap.get(MaterialProperty.property));
            Map<Object, Object> returnMap = new HashMap(oldMap);
            if (material != null) {
                ArrayList<String> keys = new ArrayList<String>();
                if (oldMap.containsKey(property)) {
                    for (JsonElement element : ((JsonElement)oldMap.get(property)).getAsJsonArray()) {
                        keys.add(element.getAsString());
                    }
                }
                if (keys.isEmpty()) {
                    keys.add("default");
                }
                if (moduleInstance.module != null) {
                    keys.add(moduleInstance.module.getName());
                }
                for (String key : keys) {
                    Map<ModuleProperty, JsonElement> materialProperties = material.materialProperties(key);
                    if (materialProperties.isEmpty()) continue;
                    returnMap = PropertyResolver.merge(oldMap, materialProperties, MergeType.SMART);
                }
            }
            return returnMap;
        });
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        return ModuleProperty.super.merge(old, toMerge, type);
    }
}

