/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.event.EventResult;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.JsonMaterial;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class NBTMaterial
extends JsonMaterial {
    public static String NBTKEY = "miapi_material";
    public static String KEY = "nbt_runtime_material";
    public JsonObject overWrite;
    public Material parent;
    public double cost = 1.0;

    public NBTMaterial(Material parent, JsonObject overwrite, boolean isClient) {
        super(parent.getDebugJson().deepCopy(), isClient);
        this.parent = parent;
        this.overWrite = overwrite;
        this.mergeJson((JsonElement)overwrite, isClient);
    }

    @Override
    public void mergeJson(JsonElement rootElement, boolean isClient) {
        JsonObject object;
        if (rootElement.isJsonObject() && (object = rootElement.getAsJsonObject()).has("cost")) {
            this.cost = ModuleProperty.getDouble(object, "cost", null, this.cost);
        }
        super.mergeJson(rootElement, isClient);
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public static void setup() {
        ReloadEvents.MAIN.subscribe(isClient -> {
            JsonObject object = new JsonObject();
            object.addProperty("key", KEY);
            MaterialProperty.materials.put(KEY, new NBTMaterial(new JsonMaterial(object, isClient), new JsonObject(), isClient));
        }, -1.0f);
        MiapiEvents.MATERIAL_CRAFT_EVENT.register(data -> {
            Material patt2063$temp = data.material;
            if (patt2063$temp instanceof NBTMaterial) {
                NBTMaterial nbtMaterial = (NBTMaterial)patt2063$temp;
                nbtMaterial.writeMaterial(data.moduleInstance);
            }
            return EventResult.pass();
        });
    }

    @Override
    public Material getMaterial(ItemModule.ModuleInstance moduleInstance) {
        String data = moduleInstance.moduleData.get("miapi:nbt_material_data");
        try {
            JsonObject object = (JsonObject)Miapi.gson.fromJson(data, JsonObject.class);
            Optional<Material> material = this.decode(object);
            return material.orElse(this);
        }
        catch (Exception e) {
            Miapi.LOGGER.error("Could not find Material", (Throwable)e);
            return this;
        }
    }

    public void writeMaterial(ItemModule.ModuleInstance moduleInstance) {
        JsonObject object1 = this.overWrite.deepCopy();
        object1.addProperty("parent", this.parent.getKey());
        moduleInstance.moduleData.put("miapi:nbt_material_data", Miapi.gson.toJson((JsonElement)object1));
    }

    @Override
    public Material getMaterialFromIngredient(ItemStack ingredient) {
        JsonObject object;
        Optional<Material> material;
        CompoundTag compound;
        Optional element;
        if (ingredient.m_41782_() && ingredient.m_41783_().m_128441_(NBTKEY) && (element = CompoundTag.f_128325_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)(compound = ingredient.m_41783_().m_128469_(NBTKEY))).result()).isPresent() && (material = this.decode(object = ((JsonElement)element.get()).getAsJsonObject())).isPresent()) {
            return material.get();
        }
        return null;
    }

    public Optional<Material> decode(JsonObject object) {
        try {
            String parentID = object.get("parent").getAsString();
            Material parent = MaterialProperty.materials.get(parentID);
            if (parent == null) {
                Miapi.LOGGER.error("Could not find Material:" + parentID);
            }
            return Optional.of(new NBTMaterial(parent, object, Environment.isClient()));
        }
        catch (Exception e) {
            Miapi.LOGGER.error("Could not find Material", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public double getValueOfItem(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_(NBTKEY)) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Double getPriorityOfIngredientItem(ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128441_(NBTKEY)) {
            return -5.0;
        }
        return null;
    }
}

