/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material.palette;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.redpxnda.nucleus.util.Color;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.SpriteContents;
import smartin.miapi.Miapi;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.palette.MaterialRenderController;
import smartin.miapi.modules.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.material.palette.SpriteColorer;
import smartin.miapi.modules.material.palette.SpriteFromJson;

public class MaskColorer
extends SpriteColorer {
    public static Map<String, Masker> maskerRegistry = new HashMap<String, Masker>();
    public Masker masker;
    public SpriteColorer base;
    public SpriteColorer layer;

    public MaskColorer(Material material, SpriteColorer base, SpriteColorer layer, Masker masker) {
        super(material);
        this.base = base;
        this.layer = layer;
        this.masker = masker;
    }

    public static MaterialRenderController fromJson(Material material, JsonElement element) {
        try {
            JsonObject object = element.getAsJsonObject();
            MaterialRenderController baseColorer = ((MaterialRenderControllers.RenderControllerCreator)MaterialRenderControllers.paletteCreator.dispatcher()).createPalette(object.get("base"), material);
            MaterialRenderController layerColorer = ((MaterialRenderControllers.RenderControllerCreator)MaterialRenderControllers.paletteCreator.dispatcher()).createPalette(object.get("layer"), material);
            if (baseColorer instanceof SpriteColorer) {
                SpriteColorer baseSpriteColor = (SpriteColorer)baseColorer;
                if (layerColorer instanceof SpriteColorer) {
                    SpriteColorer layerSpriteColor = (SpriteColorer)layerColorer;
                    Masker masker = MaskColorer.getMaskerFromJson(object.get("mask"));
                    return new MaskColorer(material, baseSpriteColor, layerSpriteColor, masker);
                }
            }
            return baseColorer;
        }
        catch (Exception e) {
            Miapi.LOGGER.error("Could not setup MaskPalette for " + material.getKey(), (Throwable)e);
            return null;
        }
    }

    public static Masker getMaskerFromJson(JsonElement element) {
        JsonObject object = element.getAsJsonObject();
        String type = object.get("type").getAsString();
        return maskerRegistry.get(type).fromJson(element);
    }

    @Override
    public Color getAverageColor() {
        return this.masker.average(this.base.getAverageColor(), this.layer.getAverageColor());
    }

    @Override
    public NativeImage transform(SpriteContents originalSprite) {
        return this.masker.mask(this.base.transform(originalSprite), this.layer.transform(originalSprite));
    }

    @Override
    public boolean doTick() {
        return this.base.doTick() || this.layer.doTick() || this.masker.isAnimated();
    }

    @Override
    public void close() throws IOException {
        this.masker.close();
        this.base.close();
        this.layer.close();
    }

    static {
        maskerRegistry.put("texture", new SpriteMasker(null));
    }

    public static interface Masker
    extends Closeable {
        public NativeImage mask(NativeImage var1, NativeImage var2);

        public Color average(Color var1, Color var2);

        public Masker fromJson(JsonElement var1);

        public boolean isAnimated();
    }

    public static class SpriteMasker
    implements Masker,
    Closeable {
        SpriteFromJson maskingSprite;
        public NativeImage lastImage = null;

        public SpriteMasker(SpriteFromJson contents) {
            this.maskingSprite = contents;
        }

        @Override
        public NativeImage mask(NativeImage base, NativeImage other) {
            NativeImageGetter.ImageHolder nativeImage = this.maskingSprite.getNativeImage();
            if (this.lastImage == null) {
                this.lastImage = new NativeImage(base.m_84982_(), base.m_85084_(), true);
                this.lastImage.m_85123_();
            }
            if (this.lastImage != null && (this.lastImage.m_85084_() != base.m_85084_() || this.lastImage.m_84982_() != base.m_84982_())) {
                this.lastImage.close();
                this.lastImage = new NativeImage(base.m_84982_(), base.m_85084_(), true);
                this.lastImage.m_85123_();
            }
            for (int width = 0; width < base.m_84982_(); ++width) {
                for (int height = 0; height < base.m_85084_(); ++height) {
                    int baseColor = base.m_84985_(width, height);
                    int otherColor = other.m_84985_(width, height);
                    int blendColor = nativeImage.getColor(width % nativeImage.getWidth(), height % nativeImage.getHeight());
                    this.lastImage.m_84988_(width, height, this.blend(baseColor, otherColor, blendColor));
                }
            }
            if (this.maskingSprite != null) {
                this.maskingSprite.markUse();
            }
            return this.lastImage;
        }

        public int blend(int base, int other, int blend) {
            int baseRed = base >> 24 & 0xFF;
            int baseGreen = base >> 16 & 0xFF;
            int baseBlue = base >> 8 & 0xFF;
            int baseAlpha = base & 0xFF;
            int otherRed = other >> 24 & 0xFF;
            int otherGreen = other >> 16 & 0xFF;
            int otherBlue = other >> 8 & 0xFF;
            int otherAlpha = other & 0xFF;
            int blendRed = blend >> 24 & 0xFF;
            int blendGreen = blend >> 16 & 0xFF;
            int blendBlue = blend >> 8 & 0xFF;
            int blendAlpha = blend & 0xFF;
            int blendedRed = (blendRed * otherRed + (255 - blendRed) * baseRed) / 255;
            int blendedGreen = (blendGreen * otherGreen + (255 - blendGreen) * baseGreen) / 255;
            int blendedBlue = (blendBlue * otherBlue + (255 - blendBlue) * baseBlue) / 255;
            int blendedAlpha = (blendAlpha * otherAlpha + (255 - blendAlpha) * baseAlpha) / 255;
            return blendedRed << 24 | blendedGreen << 16 | blendedBlue << 8 | blendedAlpha;
        }

        @Override
        public Color average(Color base, Color other) {
            return base;
        }

        @Override
        public Masker fromJson(JsonElement element) {
            SpriteFromJson sprite = new SpriteFromJson(element);
            return new SpriteMasker(sprite);
        }

        @Override
        public boolean isAnimated() {
            return this.maskingSprite.isAnimated();
        }

        @Override
        public void close() throws IOException {
            if (this.lastImage != null) {
                this.lastImage.close();
                this.lastImage = null;
            }
        }
    }
}

