/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.material.palette;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.NativeImage;
import com.redpxnda.nucleus.util.Color;
import com.redpxnda.nucleus.util.MiscUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.atlas.MaterialAtlasManager;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.modules.material.palette.SpriteColorer;

public class SpriteFromJson {
    public static final Map<String, ResourceLocation> atlasIdShortcuts = (Map)MiscUtil.initialize(new HashMap(), m -> {
        m.put("block", TextureAtlas.f_118259_);
        m.put("particle", TextureAtlas.f_118260_);
        m.put("material", MaterialAtlasManager.MATERIAL_ATLAS_ID);
    });
    public Supplier<NativeImageGetter.ImageHolder> imageSupplier;
    public boolean isAnimated;
    @Nullable
    public TextureAtlasSprite rawSprite = null;

    public SpriteFromJson(JsonElement json) {
        JsonPrimitive prim;
        if (!(json instanceof JsonObject)) {
            throw new IllegalArgumentException("json used for json sprite must be a json object!");
        }
        JsonObject obj = (JsonObject)json;
        JsonElement atlasRaw = obj.get("atlas");
        if (atlasRaw instanceof JsonPrimitive && (prim = (JsonPrimitive)atlasRaw).isString()) {
            String key = prim.getAsString();
            ResourceLocation atlasId = atlasIdShortcuts.containsKey(key) ? atlasIdShortcuts.get(key) : new ResourceLocation(key);
            ResourceLocation textureId = new ResourceLocation(obj.get("texture").getAsString());
            this.rawSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(atlasId).apply(textureId);
            SpriteContents contents = this.rawSprite.m_245424_();
            this.imageSupplier = () -> NativeImageGetter.get(contents);
            this.isAnimated = obj.has("forceTick") ? obj.get("forceTick").getAsBoolean() : SpriteColorer.isAnimatedSpriteStatic(contents);
        } else {
            this.isAnimated = obj.has("forceTick") && obj.get("forceTick").getAsBoolean();
            ResourceLocation textureId = new ResourceLocation(obj.get("texture").getAsString());
            NativeImage rawImage = SpriteFromJson.loadTexture(Minecraft.m_91087_().m_91098_(), textureId);
            NativeImageGetter.ImageHolder holder = new NativeImageGetter.ImageHolder();
            holder.nativeImage = rawImage;
            holder.width = rawImage.m_84982_();
            holder.height = rawImage.m_85084_();
            this.imageSupplier = () -> holder;
        }
    }

    public static NativeImage loadTexture(ResourceManager resourceManager, ResourceLocation id) {
        try {
            NativeImage nativeImage;
            Resource resource = resourceManager.m_215593_(id);
            try (InputStream inputStream = resource.m_215507_();){
                nativeImage = NativeImage.m_85058_((InputStream)inputStream);
            }
            return nativeImage;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to fetch texture '" + id + "' for json sprite data!", ex);
        }
    }

    public void markUse() {
        if (this.isAnimated() && this.rawSprite != null) {
            MaterialSpriteManager.markTextureAsAnimatedInUse(this.rawSprite);
        }
    }

    boolean isAnimated() {
        return this.isAnimated;
    }

    public NativeImageGetter.ImageHolder getNativeImage() {
        return this.imageSupplier.get();
    }

    public Color getAverageColor() {
        int red = 0;
        int green = 0;
        int blue = 0;
        int count = 0;
        NativeImageGetter.ImageHolder img = this.getNativeImage();
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int color = img.getColor(x, y);
                red += FastColor.ABGR32.m_266313_((int)color);
                green += FastColor.ABGR32.m_266446_((int)color);
                blue += FastColor.ABGR32.m_266247_((int)color);
                ++count;
            }
        }
        return new Color(red / count, green / count, blue / count, 255);
    }
}

