/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.properties.AbilityProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class AbilityMangerProperty
implements ModuleProperty {
    public static String KEY = "ability_context";
    public static AbilityMangerProperty property;

    public AbilityMangerProperty() {
        property = this;
        ModularItemCache.setSupplier(KEY, AbilityMangerProperty::getForCache);
    }

    private static List<ItemUseAbility> getForCache(ItemStack itemStack) {
        ArrayList<ItemUseAbility> abilities = new ArrayList<ItemUseAbility>();
        JsonElement element = ItemModule.getMergedProperty(itemStack, (ModuleProperty)property);
        if (element != null) {
            Map jsonElementMap = element.getAsJsonObject().asMap();
            jsonElementMap.keySet().forEach(s -> {
                ItemUseAbility useAbility = ItemAbilityManager.useAbilityRegistry.get((String)s);
                if (useAbility != null) {
                    abilities.add(useAbility);
                }
            });
        }
        abilities.addAll(AbilityProperty.get(itemStack));
        abilities.sort(Comparator.comparingDouble(a -> a.getAbilityContext(itemStack).getPriority()));
        return abilities;
    }

    public static List<ItemUseAbility> get(ItemStack itemStack) {
        return ModularItemCache.get(itemStack, KEY, new ArrayList());
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsJsonObject().asMap();
        return true;
    }

    public static boolean isPrimaryAbility(ItemUseAbility itemUseAbility, ItemStack itemStack) {
        List<ItemUseAbility> abilities = AbilityMangerProperty.get(itemStack);
        return !abilities.isEmpty() && itemUseAbility == abilities.get(0);
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        return ModuleProperty.mergeAsMap(old, toMerge, type);
    }

    @Nullable
    public static AbilityContext getContext(ItemStack itemStack, String key) {
        AbilityContext context = null;
        for (ItemModule.ModuleInstance moduleInstance : ItemModule.getModules(itemStack).allSubModules()) {
            Map jsonElementMap;
            JsonElement element = moduleInstance.getProperties().get(property);
            if (element == null || !(jsonElementMap = element.getAsJsonObject().asMap()).containsKey(key)) continue;
            context = new AbilityContext(((JsonElement)jsonElementMap.get(key)).getAsJsonObject(), moduleInstance, itemStack);
            context.isFullContext = true;
        }
        return context;
    }

    @Nullable
    public static AbilityContext getContext(ItemStack itemStack, ItemUseAbility ability) {
        return AbilityMangerProperty.getContext(itemStack, ItemAbilityManager.useAbilityRegistry.findKey(ability));
    }

    public static class AbilityContext {
        public JsonObject contextJson;
        public ItemModule.ModuleInstance contextInstance;
        public ItemStack contextStack;
        public ModuleCondition moduleCondition;
        public double priority = 0.0;
        public boolean isFullContext = false;
        private Map<String, Double> doubleCache = new HashMap<String, Double>();
        private Map<String, Boolean> booleanCache = new HashMap<String, Boolean>();
        private Map<String, Integer> integerCache = new HashMap<String, Integer>();
        private Map<String, String> stringCache = new HashMap<String, String>();
        private Map<String, Component> textCache = new HashMap<String, Component>();

        public AbilityContext(JsonObject element, ItemModule.ModuleInstance moduleInstance, ItemStack itemStack) {
            this.contextInstance = moduleInstance;
            this.contextJson = element;
            this.contextStack = itemStack;
            this.moduleCondition = ConditionManager.get(element.get("condition"));
            this.priority = this.getDouble("priority", 0.0);
        }

        public double getPriority() {
            return this.priority;
        }

        public double getDouble(String key, double defaultValue) {
            return this.doubleCache.computeIfAbsent(key, k -> ModuleProperty.getDouble(this.contextJson, key, this.contextInstance, defaultValue));
        }

        public boolean getBoolean(String key, boolean defaultValue) {
            return this.booleanCache.computeIfAbsent(key, k -> ModuleProperty.getBoolean(this.contextJson, key, this.contextInstance, defaultValue));
        }

        public int getInt(String key, int defaultValue) {
            return this.integerCache.computeIfAbsent(key, k -> ModuleProperty.getInteger(this.contextJson, key, this.contextInstance, defaultValue));
        }

        public String getString(String key, String defaultValue) {
            return this.stringCache.computeIfAbsent(key, k -> ModuleProperty.getString(this.contextJson, key, this.contextInstance, defaultValue));
        }

        public Component getText(String key, Component defaultValue) {
            return this.textCache.computeIfAbsent(key, k -> ModuleProperty.getText(this.contextJson, key, this.contextInstance, defaultValue));
        }
    }
}

