/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class AllowedSlots
implements ModuleProperty {
    public static final String KEY = "allowedInSlots";
    static HashMap<String, Set<ItemModule>> allowedInMap = new HashMap();

    public AllowedSlots() {
        RegistryInventory.modules.addCallback(itemModule -> AllowedSlots.getAllowedSlots(itemModule).forEach(slot -> {
            if (allowedInMap.containsKey(slot)) {
                allowedInMap.get(slot).add((ItemModule)itemModule);
            } else {
                HashSet<ItemModule> list = new HashSet<ItemModule>();
                list.add((ItemModule)itemModule);
                allowedInMap.put((String)slot, (Set<ItemModule>)list);
            }
        }));
        ReloadEvents.START.subscribe(isClient -> allowedInMap.clear());
    }

    public static List<String> getAllowedSlots(ItemModule module) {
        JsonElement data = module.getProperties().get(KEY);
        if (data == null) {
            return List.of();
        }
        Gson gson = new Gson();
        Type type = new TypeToken<List<String>>(){}.getType();
        return (List)gson.fromJson(data, type);
    }

    public static List<ItemModule> allowedIn(SlotProperty.ModuleSlot slot) {
        if (slot == null) {
            return new ArrayList<ItemModule>();
        }
        ArrayList<ItemModule> allowedModules = new ArrayList<ItemModule>();
        slot.allowed.forEach(allowedKey -> {
            if (allowedInMap.containsKey(allowedKey)) {
                allowedModules.addAll((Collection)allowedInMap.get(allowedKey));
            }
        });
        return allowedModules;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        Gson gson = new Gson();
        Type type = new TypeToken<List<String>>(){}.getType();
        gson.fromJson(data, type);
        return true;
    }
}

