/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.AttributeProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class AttributeSplitProperty
implements ModuleProperty {
    public static String KEY = "attribute_split";

    public AttributeSplitProperty() {
        AttributeProperty.attributeTransformers.add((oldMap, itemstack) -> {
            ArrayListMultimap map = ArrayListMultimap.create((Multimap)oldMap);
            Map<Context, List<SplitContext>> replaceMap = this.getMap(itemstack);
            for (Map.Entry<Context, List<SplitContext>> entry : replaceMap.entrySet()) {
                Attribute currentAttribute = entry.getKey().entityAttribute();
                EquipmentSlot equipmentSlot = entry.getKey().target();
                List<SplitContext> ratios = entry.getValue();
                if (!map.containsKey((Object)currentAttribute)) continue;
                Collection list = oldMap.get((Object)currentAttribute);
                double totalValue = list.stream().filter(attributeEntry -> attributeEntry.mergeTo().equals((Object)AttributeModifier.Operation.ADDITION)).filter(attributeEntry -> attributeEntry.slot().equals((Object)equipmentSlot)).mapToDouble(entityAttributeModifierHolder -> entityAttributeModifierHolder.attributeModifier().m_22218_()).sum();
                ratios.forEach(arg_0 -> AttributeSplitProperty.lambda$new$5(oldMap, equipmentSlot, (Multimap)map, totalValue, arg_0));
            }
            return map;
        });
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    public Map<Context, List<SplitContext>> getMap(ItemStack itemStack) {
        HashMap<Context, List<SplitContext>> finishedMap = new HashMap<Context, List<SplitContext>>();
        ItemModule.getModules(itemStack).allSubModules().forEach(moduleInstance -> {
            Map<Context, List<SplitContext>> partMap = this.getMap((ItemModule.ModuleInstance)moduleInstance);
            partMap.forEach((key, entryList) -> {
                if (finishedMap.containsKey(key)) {
                    ArrayList merge = new ArrayList((Collection)finishedMap.get(key));
                    merge.addAll(entryList);
                    finishedMap.put((Context)key, merge);
                } else {
                    finishedMap.put((Context)key, (List<SplitContext>)entryList);
                }
            });
        });
        return finishedMap;
    }

    public Map<Context, List<SplitContext>> getMap(ItemModule.ModuleInstance moduleInstance) {
        JsonElement element = moduleInstance.getProperties().get(this);
        if (element != null) {
            return this.getMap(element, moduleInstance);
        }
        return new HashMap<Context, List<SplitContext>>();
    }

    public Map<Context, List<SplitContext>> getMap(JsonElement jsonElement, ItemModule.ModuleInstance moduleInstance) {
        JsonObject object = jsonElement.getAsJsonObject();
        HashMap<Context, List<SplitContext>> contextListMap = new HashMap<Context, List<SplitContext>>();
        object.asMap().forEach((attributeKey, innerJson) -> {
            Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(attributeKey));
            if (attribute == null) {
                Miapi.LOGGER.info("could not find attribute " + attributeKey);
            } else {
                innerJson.getAsJsonObject().asMap().forEach((slotKey, data) -> {
                    try {
                        EquipmentSlot equipmentSlot = EquipmentSlot.m_20747_((String)slotKey);
                        List<SplitContext> splitContexts = data.getAsJsonArray().asList().stream().map(json -> {
                            String key = json.getAsJsonObject().get("attribute").getAsString();
                            Attribute targetAttribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(key));
                            if (targetAttribute == null) {
                                Miapi.LOGGER.info("could not find attribute " + attributeKey);
                                return null;
                            }
                            double percent = ModuleProperty.getDouble(json.getAsJsonObject(), "percentage", moduleInstance, 1.0);
                            return new SplitContext(targetAttribute, Float.valueOf((float)percent));
                        }).filter(Objects::nonNull).toList();
                        contextListMap.put(new Context(attribute, equipmentSlot), splitContexts);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Miapi.LOGGER.info("Slot not found in Attributesplitproperty " + slotKey);
                    }
                });
            }
        });
        return contextListMap;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        if (old != null && toMerge != null) {
            HashMap elementMap = new HashMap();
            Miapi.LOGGER.info(Miapi.gson.toJson(old));
            Miapi.LOGGER.info(Miapi.gson.toJson(toMerge));
            old.getAsJsonObject().asMap().forEach((key, data) -> {
                if (elementMap.containsKey(key)) {
                    JsonElement element = (JsonElement)elementMap.get(key);
                    elementMap.put(key, this.mergeAttributeTogether(element, (JsonElement)data));
                } else {
                    elementMap.put(key, data);
                }
            });
            toMerge.getAsJsonObject().asMap().forEach((key, data) -> {
                if (elementMap.containsKey(key)) {
                    JsonElement element = (JsonElement)elementMap.get(key);
                    elementMap.put(key, this.mergeAttributeTogether(element, (JsonElement)data));
                } else {
                    elementMap.put(key, data);
                }
            });
            JsonElement element = this.mergeAsMapTogether(old, toMerge, this::mergeAttributeTogether);
            Miapi.LOGGER.info(Miapi.gson.toJson(element));
            return element;
        }
        if (MergeType.EXTEND == type) {
            return old;
        }
        return toMerge;
    }

    JsonElement mergeAttributeTogether(JsonElement element, JsonElement other) {
        return this.mergeAsMapTogether(element, other, (left, right) -> this.mergeTogether(element, other));
    }

    JsonElement mergeTogether(JsonElement element, JsonElement other) {
        HashMap<String, String> map = new HashMap<String, String>();
        element.getAsJsonArray().forEach(element1 -> {
            String itemId = element1.getAsJsonObject().get("attribute").getAsString();
            String asd = element1.getAsJsonObject().get("percentage").getAsString();
            if (map.containsKey(itemId)) {
                map.put(itemId, asd + "+" + (String)map.get(itemId));
            } else {
                map.put(itemId, asd);
            }
        });
        other.getAsJsonArray().forEach(element1 -> {
            String itemId = element1.getAsJsonObject().get("attribute").getAsString();
            String asd = element1.getAsJsonObject().get("percentage").getAsString();
            if (map.containsKey(itemId)) {
                map.put(itemId, asd + "+" + (String)map.get(itemId));
            } else {
                map.put(itemId, asd);
            }
        });
        JsonObject object = new JsonObject();
        map.forEach((arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
        return object;
    }

    JsonElement mergeAsMapTogether(JsonElement old, JsonElement other, CollisionMerge collisionMerge) {
        JsonObject object = new JsonObject();
        old.getAsJsonObject().asMap().forEach((key, data) -> {
            if (object.has(key)) {
                JsonElement element = object.get(key);
                object.add(key, collisionMerge.merge(element, (JsonElement)data));
            } else {
                object.add(key, data);
            }
        });
        other.getAsJsonObject().asMap().forEach((key, data) -> {
            if (object.has(key)) {
                JsonElement element = object.get(key);
                object.add(key, collisionMerge.merge(element, (JsonElement)data));
            } else {
                object.add(key, data);
            }
        });
        return object;
    }

    private static /* synthetic */ void lambda$new$5(Multimap oldMap, EquipmentSlot equipmentSlot, Multimap map, double totalValue, SplitContext entityAttribute) {
        double value;
        Optional<AttributeProperty.EntityAttributeModifierHolder> holder;
        Collection foundAttributes = oldMap.get((Object)entityAttribute.entityAttribute());
        double baseValue = 0.0;
        UUID uuid = AttributeProperty.getUUIDForSlot(equipmentSlot, AttributeModifier.Operation.ADDITION, "miapi:attribute_split");
        if (foundAttributes != null && !foundAttributes.isEmpty() && (holder = foundAttributes.stream().filter(attributeEntry -> attributeEntry.mergeTo().equals((Object)AttributeModifier.Operation.ADDITION)).filter(attributeEntry -> attributeEntry.slot().equals((Object)equipmentSlot)).findFirst()).isPresent()) {
            baseValue = holder.get().attributeModifier().m_22218_();
            uuid = holder.get().attributeModifier().m_22209_();
            map.remove((Object)entityAttribute.entityAttribute(), (Object)holder.get());
        }
        if ((value = baseValue + totalValue * (double)entityAttribute.percent.floatValue()) != 0.0) {
            map.put((Object)entityAttribute.entityAttribute(), (Object)new AttributeProperty.EntityAttributeModifierHolder(new AttributeModifier(uuid, "miapi:attribute_split", baseValue + totalValue * (double)entityAttribute.percent.floatValue(), AttributeModifier.Operation.ADDITION), equipmentSlot, false, AttributeModifier.Operation.ADDITION));
        }
    }

    public static interface CollisionMerge {
        public JsonElement merge(JsonElement var1, JsonElement var2);
    }

    public record Context(Attribute entityAttribute, EquipmentSlot target) {
    }

    public record SplitContext(Attribute entityAttribute, Float percent) {
    }
}

