/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import dev.architectury.event.EventResult;
import net.minecraft.network.chat.Component;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.properties.CraftingConditionProperty;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class CanChangeParentModule
implements ModuleProperty {
    public static final String KEY = "allowChangeParent";

    public CanChangeParentModule() {
        CraftingConditionProperty.CRAFT_CONDITION_EVENT.register((slot, module, conditionContext) -> {
            if (slot != null && slot.inSlot != null && !module.isEmpty()) {
                for (ItemModule.ModuleInstance moduleInstance : slot.inSlot.subModules.values()) {
                    if (this.canChangeParent(moduleInstance, conditionContext)) continue;
                    conditionContext.reasons.add((Component)Component.m_237115_((String)"miapi.crafting_condition.cant_change_parent"));
                    return EventResult.interruptFalse();
                }
            }
            return EventResult.pass();
        });
    }

    public boolean canChangeParent(ItemModule.ModuleInstance moduleInstance, ConditionManager.ModuleConditionContext context) {
        JsonElement element = this.getJsonElement(moduleInstance);
        if (element != null) {
            return ConditionManager.get(element).isAllowed(context);
        }
        return true;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }
}

