/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.redpxnda.nucleus.event.PrioritizedEvent;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.properties.SlotProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class CraftingConditionProperty
implements ModuleProperty,
CraftingProperty {
    public static final String KEY = "crafting_condition";
    public static CraftingConditionProperty property;
    public static PrioritizedEvent<CanCraft> CRAFT_CONDITION_EVENT;

    public CraftingConditionProperty() {
        property = this;
    }

    public static boolean isVisible(SlotProperty.ModuleSlot slot, ItemModule module, Player entity, BlockPos pos) {
        JsonElement element = module.getKeyedProperties().get(property);
        ArrayList<Component> reasons = new ArrayList<Component>();
        if (element != null) {
            return new CraftingConditionJson(element).getVisible().isAllowed(new ConditionManager.ModuleConditionContext(slot.parent, pos, entity, module.getKeyedProperties(), reasons));
        }
        return true;
    }

    public static boolean isCraftable(SlotProperty.ModuleSlot slot, ItemModule module, Player entity, BlockPos pos) {
        CraftingConditionJson conditionJson;
        JsonElement element = module.getKeyedProperties().get(property);
        ArrayList<Component> reasons = new ArrayList<Component>();
        ItemModule.ModuleInstance instance = slot == null ? null : slot.parent;
        Map<ModuleProperty, JsonElement> elementMap = module.getKeyedProperties();
        if (instance != null) {
            elementMap = instance.getProperties();
        }
        if (element != null && !(conditionJson = new CraftingConditionJson(element)).getCraftAble().isAllowed(new ConditionManager.ModuleConditionContext(instance, pos, entity, elementMap, reasons))) {
            return false;
        }
        return !((CanCraft)CRAFT_CONDITION_EVENT.invoker()).craft(slot, module, new ConditionManager.ModuleConditionContext(instance, pos, entity, elementMap, reasons)).interruptsFurtherEvaluation();
    }

    public static void inSlotPlaced(SlotProperty.ModuleSlot slot, ItemModule module, Consumer<ItemModule.ModuleInstance> test) {
        ItemModule.ModuleInstance moduleInstance = new ItemModule.ModuleInstance(module);
        if (slot != null && slot.parent != null) {
            slot.inSlot = moduleInstance;
            moduleInstance.parent = slot.parent;
        }
        test.accept(moduleInstance);
        moduleInstance.parent = null;
        if (slot != null && slot.parent != null) {
            slot.inSlot = null;
        }
    }

    public static List<Component> getReasonsForCraftable(SlotProperty.ModuleSlot slot, ItemModule module, Player entity, BlockPos pos) {
        JsonElement element = module.getKeyedProperties().get(property);
        ArrayList<Component> reasons = new ArrayList<Component>();
        ItemModule.ModuleInstance instance = slot == null ? null : slot.parent;
        Map<ModuleProperty, JsonElement> elementMap = module.getKeyedProperties();
        if (instance != null) {
            elementMap = instance.getProperties();
        }
        if (element != null) {
            new CraftingConditionJson(element).getCraftAble().isAllowed(new ConditionManager.ModuleConditionContext(instance, pos, entity, elementMap, reasons));
        }
        ((CanCraft)CRAFT_CONDITION_EVENT.invoker()).craft(slot, module, new ConditionManager.ModuleConditionContext(instance, pos, entity, elementMap, reasons));
        return reasons;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return true;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        return ModuleProperty.super.merge(old, toMerge, type);
    }

    @Override
    public boolean shouldExecuteOnCraft(ItemModule.ModuleInstance module, ItemModule.ModuleInstance root, ItemStack stack) {
        return true;
    }

    @Override
    public Component getWarning() {
        return CraftingProperty.super.getWarning();
    }

    @Override
    public boolean canPerform(ItemStack old, ItemStack crafting, ModularWorkBenchEntity bench, Player player, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        JsonElement element;
        ItemModule.ModuleInstance newModule = craftAction.getModifyingModuleInstance(crafting);
        if (newModule != null && (element = newModule.getProperties().get(property)) != null) {
            ArrayList<Component> reasons = new ArrayList<Component>();
            return new CraftingConditionJson(element).getOnCraftAble().isAllowed(new ConditionManager.ModuleConditionContext(newModule, null, player, newModule.getProperties(), reasons));
        }
        return true;
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        return crafting;
    }

    static {
        CRAFT_CONDITION_EVENT = PrioritizedEvent.createEventResult((Object[])new CanCraft[0]);
    }

    public static class CraftingConditionJson {
        public ModuleCondition visible;
        public ModuleCondition craftAble;
        public ModuleCondition onCraft;

        public CraftingConditionJson(JsonElement element) {
            this.visible = ConditionManager.get(element.getAsJsonObject().get("visible"));
            this.craftAble = ConditionManager.get(element.getAsJsonObject().get("craftable"));
            this.onCraft = ConditionManager.get(element.getAsJsonObject().get("on_craft"));
        }

        public ModuleCondition getVisible() {
            return this.visible;
        }

        public ModuleCondition getCraftAble() {
            return this.craftAble;
        }

        public ModuleCondition getOnCraftAble() {
            return this.onCraft;
        }
    }

    public static interface CanCraft {
        public EventResult craft(SlotProperty.ModuleSlot var1, ItemModule var2, ConditionManager.ModuleConditionContext var3);
    }
}

