/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class EmissiveProperty
implements ModuleProperty {
    public static final String KEY = "emissive";
    public static EmissiveProperty property;

    public EmissiveProperty() {
        property = this;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) {
        JsonPrimitive prim;
        return data instanceof JsonPrimitive && (prim = (JsonPrimitive)data).isBoolean() || data instanceof JsonObject;
    }

    public static int[] getLightValues(ItemStack stack) {
        return EmissiveProperty.getLightValues(property.getJsonElement(stack));
    }

    public static int[] getLightValues(ItemModule.ModuleInstance instance) {
        return EmissiveProperty.getLightValues(property.getJsonElement(instance));
    }

    public static int[] getLightValues(JsonElement element) {
        JsonPrimitive primitive;
        int sky = -1;
        int block = -1;
        if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isBoolean() && primitive.getAsBoolean()) {
            sky = 15;
            block = 15;
        } else if (element instanceof JsonObject) {
            JsonPrimitive primitive2;
            JsonElement blockRaw;
            JsonPrimitive primitive3;
            JsonObject object = (JsonObject)element;
            JsonElement skyRaw = object.get("sky");
            if (skyRaw instanceof JsonPrimitive && (primitive3 = (JsonPrimitive)skyRaw).isNumber()) {
                sky = primitive3.getAsInt();
            }
            if ((blockRaw = object.get("block")) instanceof JsonPrimitive && (primitive2 = (JsonPrimitive)blockRaw).isNumber()) {
                block = primitive2.getAsInt();
            }
        }
        return new int[]{sky, block};
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        int[] oldValues = EmissiveProperty.getLightValues(old);
        int oldSky = oldValues[0];
        int oldBlock = oldValues[1];
        int[] newValues = EmissiveProperty.getLightValues(toMerge);
        int newSky = newValues[0];
        int newBlock = newValues[1];
        int sky = Math.max(newSky, oldSky);
        int block = Math.max(newBlock, oldBlock);
        JsonObject obj = new JsonObject();
        obj.addProperty("sky", (Number)sky);
        obj.addProperty("block", (Number)block);
        return obj;
    }
}

