/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.util.DoubleProperty;

public class EnchantAbilityProperty
extends DoubleProperty {
    public static String KEY = "enchantability";
    public static EnchantAbilityProperty property;

    public EnchantAbilityProperty() {
        super(KEY);
        property = this;
    }

    public static double getEnchantAbility(ItemStack itemStack) {
        List<ItemModule.ModuleInstance> moduleInstances = ItemModule.getModules(itemStack).allSubModules();
        List enchantAbilities = moduleInstances.stream().map(moduleInstance -> EnchantAbilityProperty.getEnchantAbility(moduleInstance)).sorted().collect(Collectors.toList());
        if (enchantAbilities.isEmpty()) {
            return 15.0;
        }
        if (enchantAbilities.size() > 1) {
            enchantAbilities.remove(0);
        }
        return enchantAbilities.stream().mapToDouble(Double::doubleValue).average().orElse(15.0);
    }

    public static double getEnchantAbility(ItemModule.ModuleInstance instance) {
        if (instance.getProperties().containsKey(property)) {
            return Math.max(1.0, property.getValueForModule(instance, 15.0));
        }
        Material material = MaterialProperty.getMaterial(instance);
        if (material != null) {
            return Math.max(1.0, material.getDouble("enchantability"));
        }
        return 15.0;
    }

    @Override
    public Double getValue(ItemStack stack) {
        return this.getValueRaw(stack);
    }

    @Override
    public double getValueSafe(ItemStack stack) {
        return this.getValueSafeRaw(stack);
    }
}

