/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.logging.log4j.util.TriConsumer;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class EnchantmentProperty
implements CraftingProperty,
ModuleProperty {
    public static final String KEY = "enchantments";
    public static EnchantmentProperty property;
    public static Map<String, Set<String>> replaceMap;

    public EnchantmentProperty() {
        property = this;
        ModularItemCache.setSupplier(KEY, this::createAllowedList);
        Miapi.registerReloadHandler(ReloadEvents.MAIN, "enchantment_categories", isClient -> {
            replaceMap.clear();
            EnchantmentProperty.fillMapDefault();
        }, (TriConsumer<Boolean, String, String>)((TriConsumer)(isClient, path, data) -> {
            JsonObject obj = GsonHelper.m_13864_((String)data);
            String id = obj.getAsJsonPrimitive("id").getAsString();
            if (obj.has("add")) {
                obj.getAsJsonArray("add").forEach(element -> EnchantmentProperty.addToReplaceMap(id, element.getAsJsonPrimitive().getAsString()));
            }
        }), 1.0f);
        ReloadEvents.END.subscribe(isClient -> {
            int size = 0;
            for (Set<String> entries : replaceMap.values()) {
                size += entries.size();
            }
            Miapi.LOGGER.info("Found " + size + " Enchantments");
        });
    }

    private static void fillMapDefault() {
        EnchantmentProperty.addToReplaceMap("miapi:armor", EnchantmentCategory.ARMOR);
        EnchantmentProperty.addToReplaceMap("miapi:basic", EnchantmentCategory.BREAKABLE);
        EnchantmentProperty.addToReplaceMap("miapi:weapon", EnchantmentCategory.WEAPON);
        EnchantmentProperty.addToReplaceMap("miapi:tool", EnchantmentCategory.DIGGER);
        EnchantmentProperty.addToReplaceMap("miapi:fishing_rod", EnchantmentCategory.FISHING_ROD);
        EnchantmentProperty.addToReplaceMap("miapi:bow", EnchantmentCategory.BOW);
        EnchantmentProperty.addToReplaceMap("miapi:crossbow", EnchantmentCategory.CROSSBOW);
        EnchantmentProperty.addToReplaceMap("miapi:helmet", EnchantmentCategory.ARMOR_HEAD);
        EnchantmentProperty.addToReplaceMap("miapi:chestplate", EnchantmentCategory.ARMOR_CHEST);
        EnchantmentProperty.addToReplaceMap("miapi:leggings", EnchantmentCategory.ARMOR_LEGS);
        EnchantmentProperty.addToReplaceMap("miapi:boots", EnchantmentCategory.ARMOR_FEET);
        EnchantmentProperty.addToReplaceMap("miapi:trident", EnchantmentCategory.TRIDENT);
        EnchantmentProperty.addDefault("miapi:weapon", new String[]{"miapi:basic", "miapi:tool"}, Items.f_42420_, Items.f_42425_, Items.f_42430_, Items.f_42388_, Items.f_42393_);
        EnchantmentProperty.addDefault("miapi:axe", new String[]{"miapi:basic", "miapi:tool"}, Items.f_42423_, Items.f_42428_, Items.f_42433_, Items.f_42391_, Items.f_42396_);
        EnchantmentProperty.addDefault("miapi:pickaxe", new String[]{"miapi:basic", "miapi:tool"}, Items.f_42422_, Items.f_42427_, Items.f_42432_, Items.f_42390_, Items.f_42395_);
        EnchantmentProperty.addDefault("miapi:shovel", new String[]{"miapi:basic", "miapi:tool"}, Items.f_42421_, Items.f_42426_, Items.f_42431_, Items.f_42389_, Items.f_42394_);
        EnchantmentProperty.addDefault("miapi:hoe", new String[]{"miapi:basic", "miapi:tool"}, Items.f_42424_, Items.f_42429_, Items.f_42434_, Items.f_42392_, Items.f_42397_);
        EnchantmentProperty.addDefault("miapi:edged", new String[]{"miapi:basic", "miapi:tool"}, Items.f_42420_, Items.f_42425_, Items.f_42430_, Items.f_42388_, Items.f_42393_, Items.f_42423_, Items.f_42428_, Items.f_42433_, Items.f_42391_, Items.f_42396_);
    }

    public static void addDefault(String addToID, String[] removeIDs, Item ... items) {
        BuiltInRegistries.f_256876_.m_123024_().filter(enchant -> {
            for (Item item : items) {
                if (enchant.m_6081_(item.m_7968_())) continue;
                return false;
            }
            return true;
        }).filter(enchant -> {
            for (String remove : removeIDs) {
                String enchantId;
                Set<String> replacements = replaceMap.get(remove);
                if (!replacements.contains(enchantId = BuiltInRegistries.f_256876_.m_7981_(enchant).toString())) continue;
                return false;
            }
            return true;
        }).forEach(enchant -> EnchantmentProperty.addToReplaceMap(addToID, BuiltInRegistries.f_256876_.m_7981_(enchant).toString()));
    }

    private List<Enchantment> createAllowedList(ItemStack itemStack) {
        JsonElement element = ItemModule.getMergedProperty(itemStack, (ModuleProperty)property);
        if (element != null) {
            EnchantmentPropertyJson json = (EnchantmentPropertyJson)Miapi.gson.fromJson(element, EnchantmentPropertyJson.class);
            if (json.allowed == null) {
                json.allowed = new ArrayList<String>();
            }
            if (json.forbidden == null) {
                json.forbidden = new ArrayList<String>();
            }
            List<Enchantment> enchantments = EnchantmentProperty.convert(json.allowed);
            enchantments.removeAll(EnchantmentProperty.convert(json.forbidden));
            return enchantments;
        }
        return new ArrayList<Enchantment>();
    }

    public static List<Enchantment> getAllowedList(ItemStack stack) {
        return ModularItemCache.get(stack, KEY, Collections.emptyList());
    }

    public static void addToReplaceMap(String key, String enchant) {
        Set list = replaceMap.getOrDefault(key, new HashSet());
        list.add(enchant);
        replaceMap.put(key, list);
    }

    public static void addToReplaceMap(String key, EnchantmentCategory target) {
        Set list = replaceMap.getOrDefault(key, new HashSet());
        BuiltInRegistries.f_256876_.forEach(ench -> {
            if (ench.f_44672_ == target) {
                list.add(Objects.requireNonNull(BuiltInRegistries.f_256876_.m_7981_(ench)).toString());
            }
        });
        replaceMap.put(key, list);
    }

    public static boolean isAllowed(ItemStack stack, Enchantment enchantment) {
        return EnchantmentProperty.getAllowedList(stack).contains(enchantment);
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        EnchantmentPropertyJson json = (EnchantmentPropertyJson)Miapi.gson.fromJson(data, EnchantmentPropertyJson.class);
        EnchantmentProperty.convert(json.allowed);
        EnchantmentProperty.convert(json.forbidden);
        return true;
    }

    public static List<Enchantment> convert(List<String> list) {
        ArrayList<String> replaceList = new ArrayList<String>();
        for (String id : list) {
            if (replaceMap.containsKey(id)) {
                replaceList.addAll((Collection)replaceMap.get(id));
                continue;
            }
            replaceList.add(id);
        }
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        for (String id : replaceList) {
            Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(new ResourceLocation(id));
            if (enchantment == null || enchantments.contains(enchantment)) continue;
            enchantments.add(enchantment);
        }
        return enchantments;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        switch (type) {
            case OVERWRITE: {
                return toMerge;
            }
            case EXTEND: {
                EnchantmentPropertyJson oldJson = (EnchantmentPropertyJson)Miapi.gson.fromJson(old, EnchantmentPropertyJson.class);
                EnchantmentPropertyJson mergeJson = (EnchantmentPropertyJson)Miapi.gson.fromJson(toMerge, EnchantmentPropertyJson.class);
                mergeJson.allowed.forEach(allowedEnchant -> {
                    if (!oldJson.forbidden.contains(allowedEnchant)) {
                        oldJson.allowed.add((String)allowedEnchant);
                    }
                });
                return Miapi.gson.toJsonTree((Object)oldJson);
            }
            case SMART: {
                EnchantmentPropertyJson oldJson = (EnchantmentPropertyJson)Miapi.gson.fromJson(old, EnchantmentPropertyJson.class);
                EnchantmentPropertyJson mergeJson = (EnchantmentPropertyJson)Miapi.gson.fromJson(toMerge, EnchantmentPropertyJson.class);
                mergeJson.allowed.forEach(allowedEnchant -> {
                    if (!oldJson.forbidden.contains(allowedEnchant)) {
                        oldJson.forbidden.remove(allowedEnchant);
                    }
                    oldJson.allowed.add((String)allowedEnchant);
                });
                mergeJson.forbidden.forEach(forbiddenEnchant -> {
                    if (oldJson.allowed.contains(forbiddenEnchant)) {
                        oldJson.allowed.remove(forbiddenEnchant);
                    }
                    if (!oldJson.forbidden.contains(forbiddenEnchant)) {
                        oldJson.forbidden.add((String)forbiddenEnchant);
                    }
                });
                return Miapi.gson.toJsonTree((Object)oldJson);
            }
        }
        return toMerge;
    }

    @Override
    public boolean shouldExecuteOnCraft(ItemModule.ModuleInstance module, ItemModule.ModuleInstance root, ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        List<Enchantment> allowedEnchants = EnchantmentProperty.getAllowedList(crafting);
        HashMap<Enchantment, Integer> newEnchants = new HashMap<Enchantment, Integer>();
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)crafting).entrySet()) {
            if (!allowedEnchants.contains(entry.getKey())) continue;
            newEnchants.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
        }
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)old).entrySet()) {
            if (!allowedEnchants.contains(entry.getKey())) continue;
            newEnchants.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
        }
        crafting.m_41749_("Enchantments");
        EnchantmentHelper.m_44865_(newEnchants, (ItemStack)crafting);
        return crafting;
    }

    @Override
    public List<ItemStack> performCraftAction(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<String, String> data) {
        List<Enchantment> allowedEnchants = EnchantmentProperty.getAllowedList(crafting);
        HashMap<Enchantment, Integer> newEnchants = new HashMap<Enchantment, Integer>();
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)crafting).entrySet()) {
            if (!allowedEnchants.contains(entry.getKey())) continue;
            newEnchants.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
        }
        crafting.m_41749_("Enchantments");
        EnchantmentHelper.m_44865_(newEnchants, (ItemStack)crafting);
        return CraftingProperty.super.performCraftAction(old, crafting, player, bench, craftAction, module, inventory, data);
    }

    static {
        replaceMap = new HashMap<String, Set<String>>();
    }

    public static class EnchantmentPropertyJson {
        public List<String> allowed = new ArrayList<String>();
        public List<String> forbidden = new ArrayList<String>();
    }
}

