/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import dev.architectury.event.EventResult;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.HitResult;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class EnderpearlProperty
implements ModuleProperty {
    public static final String KEY = "is_enderpearl";
    public static EnderpearlProperty property;

    public EnderpearlProperty() {
        property = this;
        MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.register(event -> {
            if (EnderpearlProperty.isEnderPearl(event.projectile) && this.onCollision(event.projectile, (HitResult)event.entityHitResult)) {
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        MiapiProjectileEvents.MODULAR_PROJECTILE_BLOCK_HIT.register(event -> {
            if (EnderpearlProperty.isEnderPearl(event.projectile) && this.onCollision(event.projectile, (HitResult)event.blockHitResult)) {
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
    }

    protected boolean onCollision(ItemProjectileEntity projectile, HitResult hitResult) {
        RandomSource random = RandomSource.m_216327_();
        for (int i = 0; i < 32; ++i) {
            projectile.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, projectile.m_20185_(), projectile.m_20186_() + random.m_188500_() * 2.0, projectile.m_20189_(), random.m_188583_(), 0.0, random.m_188583_());
        }
        if (!projectile.m_9236_().f_46443_ && !projectile.m_213877_()) {
            Entity entity = projectile.m_19749_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
                if (serverPlayerEntity.f_8906_.m_6198_() && serverPlayerEntity.m_9236_() == projectile.m_9236_() && !serverPlayerEntity.m_5803_()) {
                    Endermite endermiteEntity;
                    if (random.m_188501_() < 0.05f && projectile.m_9236_().m_46469_().m_46207_(GameRules.f_46134_) && (endermiteEntity = (Endermite)EntityType.f_20567_.m_20615_(projectile.m_9236_())) != null) {
                        endermiteEntity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), entity.m_146909_());
                        projectile.m_9236_().m_7967_((Entity)endermiteEntity);
                    }
                    if (entity.m_20159_()) {
                        serverPlayerEntity.m_142098_(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_());
                    } else {
                        entity.m_6021_(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_());
                    }
                    entity.m_183634_();
                    entity.m_6469_(projectile.m_269291_().m_268989_(), 5.0f);
                }
            } else if (entity != null) {
                entity.m_6021_(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_());
                entity.m_183634_();
            }
            projectile.m_146870_();
            return true;
        }
        return false;
    }

    public static boolean isEnderPearl(ItemProjectileEntity projectile) {
        return EnderpearlProperty.isEnderPearl(projectile.m_7941_());
    }

    public static boolean isEnderPearl(ItemStack itemStack) {
        JsonElement element = ItemModule.getMergedProperty(itemStack, (ModuleProperty)property);
        if (element != null) {
            return element.getAsBoolean();
        }
        return false;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsBoolean();
        return true;
    }
}

