/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class FakeItemTagProperty
implements ModuleProperty {
    public static final String KEY = "fake_item_tag";
    public static FakeItemTagProperty property;

    public FakeItemTagProperty() {
        property = this;
    }

    public static List<String> getTags(ItemStack itemStack) {
        return FakeItemTagProperty.getTags(ItemModule.getMergedProperty(itemStack, (ModuleProperty)property));
    }

    public static boolean hasTag(ResourceLocation identifier, ItemStack itemStack) {
        return FakeItemTagProperty.getTags(itemStack).contains(identifier.toString());
    }

    public static List<String> getTags(JsonElement data) {
        ArrayList<String> tags = new ArrayList<String>();
        if (data != null) {
            data.getAsJsonArray().forEach(element -> tags.add(element.getAsString()));
        }
        return tags;
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        data.getAsJsonArray().forEach(JsonElement::getAsString);
        return true;
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        switch (type) {
            case SMART: 
            case EXTEND: {
                JsonElement element = old.deepCopy();
                element.getAsJsonArray().addAll(toMerge.getAsJsonArray());
                return element;
            }
            case OVERWRITE: {
                return toMerge;
            }
        }
        return old;
    }
}

