/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redpxnda.nucleus.codec.misc.MiscCodecs;
import com.redpxnda.nucleus.event.PrioritizedEvent;
import com.redpxnda.nucleus.util.Color;
import dev.architectury.event.EventResult;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.Util;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class GlintProperty
implements ModuleProperty {
    public static GlintProperty property;
    public static final String KEY = "glint_settings";
    public static Map<String, GlintSettings> glintSettingsMap;
    public static PrioritizedEvent<GlintGetter> GLINT_RESOLVE;
    public static GlintSettings defaultSettings;

    public GlintProperty() {
        property = this;
        glintSettingsMap.put("rainbow", new SettingsControlledGlint());
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return false;
    }

    public GlintSettings getGlintSettings(ItemModule.ModuleInstance instance, ItemStack stack) {
        return GlintProperty.getStatic(instance, stack);
    }

    static GlintSettings getStatic(ItemModule.ModuleInstance instance, ItemStack stack) {
        String type;
        JsonElement element = instance.getProperties().get(property);
        if (element != null && element.getAsJsonObject().has("type") && glintSettingsMap.containsKey(type = element.getAsJsonObject().get("type").getAsString())) {
            return glintSettingsMap.get("type").get(instance, stack);
        }
        AtomicReference<GlintSettings> reference = new AtomicReference<GlintSettings>(defaultSettings);
        ((GlintGetter)GLINT_RESOLVE.invoker()).get(stack, instance, reference);
        return reference.get();
    }

    public static void updateConfig() {
        Color[] newColors = new Color[MiapiConfig.INSTANCE.client.other.enchantColors.size()];
        for (int i = 0; i < newColors.length; ++i) {
            newColors[i] = MiapiConfig.INSTANCE.client.other.enchantColors.get(i);
        }
        SettingsControlledGlint glintSettings = new SettingsControlledGlint();
        glintSettings.colors = newColors;
        glintSettings.rainbowSpeed = MiapiConfig.INSTANCE.client.other.enchantingGlintSpeed;
        defaultSettings = glintSettings;
        ModularItemCache.discardCache();
    }

    static {
        glintSettingsMap = new HashMap<String, GlintSettings>();
        GLINT_RESOLVE = PrioritizedEvent.createLoop((Object[])new GlintGetter[0]);
        defaultSettings = new SettingsControlledGlint();
    }

    public static class SettingsControlledGlint
    extends RainbowGlintSettings {
        @Override
        public GlintSettings get(ItemModule.ModuleInstance instance, ItemStack stack) {
            JsonElement element = instance.getProperties().get(property);
            SettingsControlledGlint rainbowGlintSettings = new SettingsControlledGlint();
            rainbowGlintSettings.shouldRenderGlint = stack.m_41790_();
            if (element != null) {
                if (element.getAsJsonObject().has("rainbowSpeed")) {
                    rainbowGlintSettings.rainbowSpeed = (float)StatResolver.resolveDouble(element.getAsJsonObject().get("rainbowSpeed"), instance);
                }
                if (element.getAsJsonObject().has("speed")) {
                    rainbowGlintSettings.speed = (float)StatResolver.resolveDouble(element.getAsJsonObject().get("speed"), instance);
                }
                if (element.getAsJsonObject().has("strength")) {
                    rainbowGlintSettings.strength = (float)StatResolver.resolveDouble(element.getAsJsonObject().get("strength"), instance);
                }
                if (element.getAsJsonObject().has("should_render")) {
                    rainbowGlintSettings.shouldRenderGlint = element.getAsJsonObject().get("should_render").getAsBoolean();
                }
            }
            return rainbowGlintSettings;
        }
    }

    public static interface GlintSettings {
        public GlintSettings get(ItemModule.ModuleInstance var1, ItemStack var2);

        public float getA();

        public Color getColor();

        public float getSpeed();

        default public void applySpeed() {
            RegistryInventory.Client.glintShader.m_173356_("GlintSpeed").m_5985_(this.getSpeed());
        }

        default public void applyAlpha() {
            RegistryInventory.Client.glintShader.m_173356_("GlintStrength").m_5985_(this.getA());
        }

        public boolean shouldRender();
    }

    public static interface GlintGetter {
        public EventResult get(ItemStack var1, ItemModule.ModuleInstance var2, AtomicReference<GlintSettings> var3);
    }

    public static abstract class RainbowGlintSettings
    implements GlintSettings {
        public float speed = 1.0f;
        public float rainbowSpeed = 1.0f;
        public float strength = 1.0f;
        public boolean shouldRenderGlint;
        public Color[] colors;

        public RainbowGlintSettings(float speed, float rainbowSpeed, float strength, boolean shouldRenderGlint, Color[] colors) {
            this.speed = speed;
            this.rainbowSpeed = rainbowSpeed;
            this.strength = strength;
            this.shouldRenderGlint = shouldRenderGlint;
            this.colors = colors;
        }

        public RainbowGlintSettings() {
        }

        @Override
        public float getA() {
            return this.strength;
        }

        public Color getColorold() {
            long time = Util.m_137550_();
            double scaledTime = (double)time / 3000.0 * (double)this.rainbowSpeed;
            int lowerColorIndex = (int)Math.floor(scaledTime %= (double)this.colors.length);
            int higherColorIndex = (lowerColorIndex + 1) % this.colors.length;
            float percent = (float)(scaledTime - (double)lowerColorIndex);
            float otherPercent = 1.0f - percent;
            return new Color(this.colors[lowerColorIndex].redAsFloat() * percent + this.colors[higherColorIndex].redAsFloat() * otherPercent, this.colors[lowerColorIndex].greenAsFloat() * percent + this.colors[higherColorIndex].greenAsFloat() * otherPercent, this.colors[lowerColorIndex].blueAsFloat() * percent + this.colors[higherColorIndex].blueAsFloat() * otherPercent, this.colors[lowerColorIndex].alphaAsFloat() * percent + this.colors[higherColorIndex].alphaAsFloat() * otherPercent);
        }

        @Override
        public Color getColor() {
            long time = Util.m_137550_();
            double scaledTime = (double)time / 3000.0 * (double)this.rainbowSpeed;
            int lowerColorIndex = (int)Math.floor(scaledTime %= (double)this.colors.length);
            int higherColorIndex = (lowerColorIndex + 1) % this.colors.length;
            float percent = (float)(scaledTime - Math.floor(scaledTime));
            float otherPercent = 1.0f - percent;
            Color lowerColor = this.colors[higherColorIndex];
            Color higherColor = this.colors[lowerColorIndex];
            return new Color(lowerColor.redAsFloat() * percent + higherColor.redAsFloat() * otherPercent, lowerColor.greenAsFloat() * percent + higherColor.greenAsFloat() * otherPercent, lowerColor.blueAsFloat() * percent + higherColor.blueAsFloat() * otherPercent, lowerColor.alphaAsFloat() * percent + higherColor.alphaAsFloat() * otherPercent);
        }

        @Override
        public float getSpeed() {
            return this.speed;
        }

        public float getColor(int colorNo) {
            long time = Util.m_137550_();
            double scaledTime = (double)time / 3000.0 * (double)this.rainbowSpeed;
            return (float)Math.max(0.0, Math.min(1.0, Math.abs((scaledTime + (double)(colorNo * 2)) % (double)(this.colors.length * 2) - (double)this.colors.length) - (double)(this.colors.length - 2)));
        }

        @Override
        public boolean shouldRender() {
            return this.shouldRenderGlint;
        }
    }

    public static class JsonGlintSettings
    implements GlintSettings {
        public Color color;
        public float a = 1.0f;
        public float speed = 1.0f;
        public boolean shouldRenderGlint;

        public JsonGlintSettings(ItemModule.ModuleInstance instance, ItemStack stack) {
            this.shouldRenderGlint = stack.m_41790_();
            JsonElement element = instance.getProperties().get(property);
            if (element != null) {
                if (element.getAsJsonObject().has("color")) {
                    this.color = (Color)MiscCodecs.COLOR.parse((DynamicOps)JsonOps.INSTANCE, (Object)element.getAsJsonObject().get("color")).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to decode using color for GlintProperty! -> " + s));
                    this.a = this.color.a() * 2;
                }
                if (element.getAsJsonObject().has("speed")) {
                    this.speed = (float)StatResolver.resolveDouble(element.getAsJsonObject().get("speed"), instance);
                }
                if (element.getAsJsonObject().has("should_render")) {
                    this.shouldRenderGlint = element.getAsJsonObject().get("should_render").getAsBoolean();
                }
            }
        }

        @Override
        public GlintSettings get(ItemModule.ModuleInstance instance, ItemStack stack) {
            String type;
            JsonElement element = instance.getProperties().get(property);
            if (element.getAsJsonObject().has("type") && glintSettingsMap.containsKey(type = element.getAsJsonObject().get("type").getAsString())) {
                return glintSettingsMap.get("type").get(instance, stack);
            }
            return new JsonGlintSettings(instance, stack);
        }

        @Override
        public float getA() {
            return this.a;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public float getSpeed() {
            return this.speed;
        }

        @Override
        public boolean shouldRender() {
            return this.shouldRenderGlint;
        }
    }
}

