/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.crafting.crafter.replace.HoverMaterialList;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.material.Material;
import smartin.miapi.modules.material.MaterialProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class LoreProperty
implements ModuleProperty {
    public static final String KEY = "itemLore";
    public static final Codec<Holder> codec = AutoCodec.of(Holder.class).codec();
    public static LoreProperty property;
    public static List<LoreSupplier> bottomLoreSuppliers;
    public static List<ToolTipSupplierSupplier> loreSuppliers;
    public static Map<ItemStack, Material> materialLookupTable;

    public LoreProperty() {
        property = this;
        loreSuppliers.add((itemStack, world, tooltip, context) -> {
            if (itemStack.m_41720_() instanceof ModularItem) {
                tooltip.add(this.format((Component)Component.m_237115_((String)"miapi.ui.modular_item"), ChatFormatting.GRAY));
                this.getHolders(itemStack).stream().filter(h -> h.position.equals("top")).forEach(holder -> tooltip.add(holder.getText()));
            }
        });
    }

    public List<Holder> getHolders(ItemStack itemStack) {
        return this.getHolders(ItemModule.getMergedProperty(itemStack, (ModuleProperty)property));
    }

    public List<Holder> getHolders(JsonElement element) {
        ArrayList<Holder> holders = new ArrayList<Holder>();
        if (element != null) {
            if (element.isJsonArray()) {
                element.getAsJsonArray().forEach(element1 -> holders.add(this.getFromSingleElement((JsonElement)element1)));
            } else {
                holders.add(this.getFromSingleElement(element));
            }
        }
        return holders.stream().sorted().collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public JsonElement merge(JsonElement old, JsonElement toMerge, MergeType type) {
        if (MergeType.OVERWRITE.equals((Object)type)) {
            return ModuleProperty.mergeToList(old, toMerge);
        }
        return old;
    }

    private Holder getFromSingleElement(JsonElement element) {
        return (Holder)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(false, s -> Miapi.LOGGER.error("Failed to decode using codec during cache creation for a CodecBasedProperty! -> " + s));
    }

    private Component gray(Component text) {
        return this.format(text, ChatFormatting.GRAY);
    }

    private Component format(Component text, ChatFormatting ... formatting) {
        return (Component)text.m_178405_(Style.f_131099_.m_131152_(formatting)).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectTooltipOnNonModularItems(List<Component> tooltip, ItemStack itemStack) {
        LoreProperty loreProperty = property;
        synchronized (loreProperty) {
            if (Environment.isClient()) {
                tooltip.addAll(this.addToolTipsClient(itemStack));
            } else {
                tooltip.addAll(this.addToolTipsServer(itemStack));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    List<Component> addToolTipsClient(ItemStack itemStack) {
        ItemStack converted;
        Material material;
        ArrayList<Component> lines = new ArrayList<Component>();
        if (MiapiConfig.INSTANCE.client.other.injectLoreModularMaterial && (material = materialLookupTable.computeIfAbsent(itemStack, itemStack1 -> MaterialProperty.getMaterialFromIngredient(itemStack))) != null) {
            int i = material.getGroups().size();
            if (i == 1) {
                if (MiapiConfig.INSTANCE.client.other.injectLoreWithoutGroup) {
                    lines.add(this.gray((Component)Component.m_237115_((String)"miapi.ui.material_desc")));
                }
            } else {
                Component materialDesc = this.gray((Component)Component.m_237115_((String)"miapi.ui.material_desc_alt"));
                lines.add(materialDesc);
                if (Environment.isClient()) {
                    lines.addAll(this.getAltClient(material));
                }
            }
        }
        if (MiapiConfig.INSTANCE.client.other.injectLoreModularItem && (!ItemStack.m_41728_((ItemStack)(converted = ModularItemStackConverter.getModularVersion(itemStack)), (ItemStack)itemStack) || itemStack.m_41720_() instanceof ModularItem)) {
            lines.add(this.format((Component)Component.m_237115_((String)"miapi.ui.modular_item"), ChatFormatting.GRAY));
        }
        return lines;
    }

    @OnlyIn(value=Dist.CLIENT)
    List<Component> getAltClient(Material material) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (Screen.m_96639_()) {
            lines.add(this.gray((Component)Component.m_237115_((String)"miapi.ui.material_desc_alt_2")));
            for (int i = 1; i < material.getGuiGroups().size(); ++i) {
                String groupId = material.getGuiGroups().get(i);
                lines.add(this.gray((Component)Component.m_237113_((String)(" - " + HoverMaterialList.getTranslation(groupId).getString()))));
            }
        }
        return lines;
    }

    List<Component> addToolTipsServer(ItemStack itemStack) {
        ItemStack converted;
        Material material;
        ArrayList<Component> lines = new ArrayList<Component>();
        if (MiapiConfig.INSTANCE.client.other.injectLoreModularMaterial && (material = materialLookupTable.computeIfAbsent(itemStack, itemStack1 -> MaterialProperty.getMaterialFromIngredient(itemStack))) != null) {
            int i = material.getGroups().size();
            if (i == 1) {
                if (MiapiConfig.INSTANCE.client.other.injectLoreWithoutGroup) {
                    lines.add(this.gray((Component)Component.m_237115_((String)"miapi.ui.material_desc")));
                }
            } else {
                Component materialDesc = this.gray((Component)Component.m_237115_((String)"miapi.ui.material_desc_alt"));
                lines.add(materialDesc);
            }
        }
        if (MiapiConfig.INSTANCE.client.other.injectLoreModularItem && (!ItemStack.m_41728_((ItemStack)(converted = ModularItemStackConverter.getModularVersion(itemStack)), (ItemStack)itemStack) || itemStack.m_41720_() instanceof ModularItem)) {
            lines.add(this.format((Component)Component.m_237115_((String)"miapi.ui.modular_item"), ChatFormatting.GRAY));
        }
        return lines;
    }

    public static void appendLoreTop(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        loreSuppliers.forEach(supplierSupplier -> supplierSupplier.getLore(stack, world, tooltip, context));
    }

    public void appendLoreBottom(List<Component> oldLore, ItemStack itemStack) {
        bottomLoreSuppliers.forEach(loreSupplier -> oldLore.addAll(loreSupplier.getLore(itemStack)));
        this.getHolders(itemStack).stream().filter(h -> h.position.equals("bottom")).forEach(holder -> oldLore.add(holder.getText()));
    }

    @Override
    public boolean load(String moduleKey, JsonElement data) throws Exception {
        return false;
    }

    static {
        bottomLoreSuppliers = Collections.synchronizedList(new ArrayList());
        loreSuppliers = Collections.synchronizedList(new ArrayList());
        materialLookupTable = Collections.synchronizedMap(new WeakHashMap());
    }

    public static interface ToolTipSupplierSupplier {
        public void getLore(ItemStack var1, @Nullable Level var2, List<Component> var3, TooltipFlag var4);
    }

    public static class Holder
    implements Comparable<Holder> {
        @CodecBehavior.Optional
        @Deprecated
        public String lang;
        @CodecBehavior.Optional
        public Component text;
        @CodecBehavior.Optional(value=false)
        public String position;
        @CodecBehavior.Optional
        public float priority = 0.0f;

        public Component getText() {
            if (this.lang != null) {
                return Component.m_237115_((String)this.lang);
            }
            if (this.text != null) {
                return this.text;
            }
            return Component.m_237119_();
        }

        @Override
        public int compareTo(@NotNull Holder o) {
            return Float.compare(this.priority, o.priority);
        }
    }

    public static interface LoreSupplier {
        public List<Component> getLore(ItemStack var1);
    }
}

